/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.launch4j.ant.AntClassPath;
import net.sf.launch4j.ant.AntJre;
import net.sf.launch4j.ant.Messages;
import net.sf.launch4j.ant.StringWrapper;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.Msg;
import net.sf.launch4j.config.SingleInstance;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;
import org.apache.tools.ant.BuildException;

public class AntConfig
extends Config {
    private final List<StringWrapper> wrappedHeaderObjects = new ArrayList<StringWrapper>();
    private final List<StringWrapper> wrappedLibs = new ArrayList<StringWrapper>();
    private final List<StringWrapper> wrappedVariables = new ArrayList<StringWrapper>();

    public void setJarPath(String path) {
        this.setJar(new File(path));
    }

    public void addObj(StringWrapper obj) {
        this.wrappedHeaderObjects.add(obj);
    }

    public void addLib(StringWrapper lib) {
        this.wrappedLibs.add(lib);
    }

    public void addVar(StringWrapper var) {
        this.wrappedVariables.add(var);
    }

    public void addSingleInstance(SingleInstance singleInstance) {
        this.checkNull(this.getSingleInstance(), "singleInstance");
        this.setSingleInstance(singleInstance);
    }

    public void addClassPath(AntClassPath classPath) {
        this.checkNull(this.getClassPath(), "classPath");
        this.setClassPath(classPath);
    }

    public void addJre(AntJre jre) {
        this.checkNull(this.getJre(), "jre");
        this.setJre(jre);
    }

    public void addSplash(Splash splash) {
        this.checkNull(this.getSplash(), "splash");
        this.setSplash(splash);
    }

    public void addVersionInfo(VersionInfo versionInfo) {
        this.checkNull(this.getVersionInfo(), "versionInfo");
        this.setVersionInfo(versionInfo);
    }

    public void addMessages(Msg messages) {
        this.checkNull(this.getMessages(), "messages");
        this.setMessages(messages);
    }

    public void unwrap() {
        this.setHeaderObjects(StringWrapper.unwrap(this.wrappedHeaderObjects));
        this.setLibs(StringWrapper.unwrap(this.wrappedLibs));
        this.setVariables(StringWrapper.unwrap(this.wrappedVariables));
        if (this.getClassPath() != null) {
            ((AntClassPath)this.getClassPath()).unwrap();
        }
        if (this.getJre() != null) {
            ((AntJre)this.getJre()).unwrap();
        }
    }

    private void checkNull(Object o, String name) {
        if (o != null) {
            throw new BuildException(Messages.getString("AntConfig.duplicate.element") + ": " + name);
        }
    }
}

