/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class ExportTool
extends ToolBase {
    static Set<String> formats = Set.of("javabin", "json", "jsonl");

    public ExportTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"url").longOpt("solr-collection-url").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --solr-url and -c / --name instead").get()).hasArg().argName("URL").desc("Address of the collection, example http://localhost:8983/solr/gettingstarted.").build(), Option.builder((String)"c").longOpt("name").hasArg().argName("NAME").desc("Name of the collection.").build(), Option.builder((String)"out").hasArg().argName("PATH").desc("Path to output the exported data, and optionally the file name, defaults to 'collection-name'.").build(), Option.builder((String)"format").hasArg().argName("FORMAT").desc("Output format for exported docs (json, jsonl or javabin), defaulting to json.").build(), Option.builder((String)"compress").desc("Compress the output.").build(), Option.builder((String)"limit").hasArg().argName("#").desc("Maximum number of docs to download. Default is 100, use -1 for all docs.").build(), Option.builder((String)"query").hasArg().argName("QUERY").desc("A custom query, default is '*:*'.").build(), Option.builder((String)"fields").hasArg().argName("FIELDA,FIELDB").desc("Comma separated list of fields to export. By default all fields are fetched.").build(), SolrCLI.OPTION_SOLRURL);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        Object url = null;
        if (cli.hasOption("solr-url")) {
            if (!cli.hasOption("name")) {
                throw new IllegalArgumentException("Must specify -c / --name parameter with --solr-url to post documents.");
            }
            url = SolrCLI.normalizeSolrUrl(cli) + "/solr/" + cli.getOptionValue("name");
        } else if (cli.hasOption("solr-collection-url")) {
            url = cli.getOptionValue("solr-collection-url");
        } else {
            throw new IllegalArgumentException("Must specify --solr-url.");
        }
        MultiThreadedRunner info = new MultiThreadedRunner(this.runtime, (String)url);
        info.query = cli.getOptionValue("query", "*:*");
        info.setOutFormat(cli.getOptionValue("out"), cli.getOptionValue("format"), cli.hasOption("compress"));
        info.fields = cli.getOptionValue("fields");
        info.setLimit(cli.getOptionValue("limit", "100"));
        ((Info)info).exportDocs();
    }

    static long getDocCount(String coreName, SolrClient client, String query) throws SolrServerException, IOException {
        SolrQuery q = new SolrQuery(query);
        q.setRows(Integer.valueOf(0));
        q.add("distrib", new String[]{"false"});
        QueryRequest request = new QueryRequest((SolrParams)q);
        NamedList res = client.request((SolrRequest)request, coreName);
        SolrDocumentList sdl = (SolrDocumentList)res.get("response");
        return sdl.getNumFound();
    }

    static class MultiThreadedRunner
    extends Info {
        ExecutorService producerThreadpool;
        ExecutorService consumerThreadpool;
        ArrayBlockingQueue<SolrDocument> queue = new ArrayBlockingQueue(1000);
        SolrDocument EOFDOC = new SolrDocument();
        volatile boolean failed = false;
        Map<String, CoreHandler> corehandlers = new HashMap<String, CoreHandler>();
        private final long startTime = System.currentTimeMillis();

        @SuppressForbidden(reason="Need to print out time")
        public MultiThreadedRunner(ToolRuntime runtime, String url) {
            super(runtime, url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressForbidden(reason="Need to print out time")
        void exportDocs() throws Exception {
            this.sink = this.getSink();
            this.fetchUniqueKey();
            ClusterStateProvider stateProvider = this.solrClient.getClusterStateProvider();
            DocCollection coll = stateProvider.getCollection(this.coll);
            Map m = coll.getSlicesMap();
            this.producerThreadpool = ExecutorUtil.newMDCAwareFixedThreadPool((int)m.size(), (ThreadFactory)new SolrNamedThreadFactory("solrcli-exporter-producers"));
            this.consumerThreadpool = ExecutorUtil.newMDCAwareFixedThreadPool((int)1, (ThreadFactory)new SolrNamedThreadFactory("solrcli-exporter-consumer"));
            this.sink.start();
            CountDownLatch consumerlatch = new CountDownLatch(1);
            try {
                this.addConsumer(consumerlatch);
                this.addProducers(m);
                this.runtime.println("Number of shards : " + this.corehandlers.size());
                CountDownLatch producerLatch = new CountDownLatch(this.corehandlers.size());
                this.corehandlers.forEach((s, coreHandler) -> this.producerThreadpool.execute(() -> {
                    try {
                        coreHandler.exportDocsFromCore();
                    }
                    catch (Exception e) {
                        this.runtime.println("Error exporting docs from : " + s);
                    }
                    producerLatch.countDown();
                }));
                producerLatch.await();
                this.queue.offer(this.EOFDOC, 10L, TimeUnit.SECONDS);
                consumerlatch.await();
            }
            finally {
                this.sink.end();
                this.solrClient.close();
                this.producerThreadpool.shutdownNow();
                this.consumerThreadpool.shutdownNow();
                if (this.failed) {
                    try {
                        Files.delete(new File(this.out).toPath());
                    }
                    catch (IOException iOException) {}
                }
                System.out.println("\nTotal Docs exported: " + this.docsWritten.get() + ". Time elapsed: " + (System.currentTimeMillis() - this.startTime) / 1000L + "seconds");
            }
        }

        private void addProducers(Map<String, Slice> m) {
            for (Map.Entry<String, Slice> entry : m.entrySet()) {
                Slice slice = entry.getValue();
                Replica replica = slice.getLeader();
                if (replica == null) {
                    replica = (Replica)slice.getReplicas().iterator().next();
                }
                CoreHandler coreHandler = new CoreHandler(replica);
                this.corehandlers.put(replica.getCoreName(), coreHandler);
            }
        }

        private void addConsumer(CountDownLatch consumerlatch) {
            this.consumerThreadpool.execute(() -> {
                while (true) {
                    SolrDocument doc;
                    try {
                        doc = this.queue.poll(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        this.runtime.println("Consumer interrupted");
                        this.failed = true;
                        break;
                    }
                    if (doc == this.EOFDOC) break;
                    try {
                        if (this.docsWritten.get() >= this.limit) continue;
                        this.sink.accept(doc);
                    }
                    catch (Exception e) {
                        this.runtime.println("Failed to write to file " + e.getMessage());
                        this.failed = true;
                    }
                }
                consumerlatch.countDown();
            });
        }

        class CoreHandler {
            final Replica replica;
            long expectedDocs;
            AtomicLong receivedDocs = new AtomicLong();

            CoreHandler(Replica replica) {
                this.replica = replica;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            boolean exportDocsFromCore() throws IOException, SolrServerException {
                try (Http2SolrClient client = new Http2SolrClient.Builder(MultiThreadedRunner.this.baseurl).build();){
                    this.expectedDocs = ExportTool.getDocCount(this.replica.getCoreName(), (SolrClient)client, MultiThreadedRunner.this.query);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.add("q", new String[]{MultiThreadedRunner.this.query});
                    if (MultiThreadedRunner.this.fields != null) {
                        params.add("fl", new String[]{MultiThreadedRunner.this.fields});
                    }
                    params.add("sort", new String[]{MultiThreadedRunner.this.uniqueKey + " asc"});
                    params.add("distrib", new String[]{"false"});
                    params.add("rows", new String[]{"1000"});
                    String cursorMark = "*";
                    Consumer<SolrDocument> wrapper = doc -> {
                        try {
                            MultiThreadedRunner.this.queue.offer((SolrDocument)doc, 10L, TimeUnit.SECONDS);
                            this.receivedDocs.incrementAndGet();
                        }
                        catch (InterruptedException e) {
                            MultiThreadedRunner.this.failed = true;
                            MultiThreadedRunner.this.runtime.println("Failed to write docs from" + e.getMessage());
                        }
                    };
                    StreamingBinaryResponseParser responseParser = new StreamingBinaryResponseParser(Info.getStreamer(wrapper));
                    while (true) {
                        String nextCursorMark;
                        if (MultiThreadedRunner.this.failed) {
                            boolean bl = false;
                            return bl;
                        }
                        if (MultiThreadedRunner.this.docsWritten.get() > MultiThreadedRunner.this.limit) {
                            boolean bl = true;
                            return bl;
                        }
                        params.set("cursorMark", new String[]{cursorMark});
                        QueryRequest request = new QueryRequest((SolrParams)params);
                        request.setResponseParser((ResponseParser)responseParser);
                        try {
                            NamedList rsp = client.request((SolrRequest)request, this.replica.getCoreName());
                            nextCursorMark = (String)rsp.get("nextCursorMark");
                            if (nextCursorMark == null || Objects.equals(cursorMark, nextCursorMark)) {
                                MultiThreadedRunner.this.runtime.println(StrUtils.formatString((String)"\nExport complete from shard {0}, core {1}, docs received: {2}", (Object[])new Object[]{this.replica.getShard(), this.replica.getCoreName(), this.receivedDocs.get()}));
                                if (this.expectedDocs != this.receivedDocs.get()) {
                                    MultiThreadedRunner.this.runtime.println(StrUtils.formatString((String)"Could not download all docs from core {0}, docs expected: {1}, received: {2}", (Object[])new Object[]{this.replica.getCoreName(), this.expectedDocs, this.receivedDocs.get()}));
                                    boolean bl = false;
                                    return bl;
                                }
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (SolrServerException e) {
                            MultiThreadedRunner.this.runtime.println("Error reading from server " + this.replica.getBaseUrl() + "/" + this.replica.getCoreName());
                            MultiThreadedRunner.this.failed = true;
                            boolean bl = false;
                            return bl;
                        }
                        {
                            cursorMark = nextCursorMark;
                            MultiThreadedRunner.this.runtime.print(".");
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    static class JavabinSink
    extends DocsSink {
        JavaBinCodec codec;
        private final BiConsumer<String, Object> bic = new BiConsumer<String, Object>(){

            @Override
            public void accept(String s, Object o) {
                try {
                    if (s.equals("_version_") || s.equals("_root_")) {
                        return;
                    }
                    codec.writeExternString((CharSequence)s);
                    codec.writeVal(o);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        public JavabinSink(Info info) {
            this.info = info;
        }

        @Override
        public void start() throws IOException {
            this.fos = new FileOutputStream(this.info.out);
            if (this.info.compress) {
                this.fos = new GZIPOutputStream(this.fos);
            }
            if (this.info.bufferSize > 0) {
                this.fos = new BufferedOutputStream(this.fos, this.info.bufferSize);
            }
            this.codec = new JavaBinCodec(this.fos, null);
            this.codec.writeTag((byte)-64, 2);
            this.codec.writeStr((CharSequence)"params");
            this.codec.writeNamedList(new NamedList());
            this.codec.writeStr((CharSequence)"docs");
            this.codec.writeTag((byte)14);
        }

        @Override
        public void end() throws IOException {
            this.codec.writeTag((byte)15);
            this.codec.close();
            this.fos.flush();
            this.fos.close();
        }

        @Override
        public synchronized void accept(SolrDocument doc) throws IOException {
            int sz = doc.size();
            if (doc.containsKey((Object)"_version_")) {
                --sz;
            }
            if (doc.containsKey((Object)"_root_")) {
                --sz;
            }
            this.codec.writeTag((byte)16, sz);
            this.codec.writeFloat(1.0f);
            doc.forEach(this.bic);
            super.accept(doc);
        }
    }

    static class JsonSink
    extends DocsSink {
        private final CharArr charArr = new CharArr(2048);
        JSONWriter jsonWriter = new JSONWriter(this.charArr, -1);
        private Writer writer;
        private boolean firstDoc = true;

        public JsonSink(Info info) {
            this.info = info;
        }

        @Override
        public void start() throws IOException {
            this.fos = new FileOutputStream(this.info.out);
            if (this.info.compress) {
                this.fos = new GZIPOutputStream(this.fos);
            }
            if (this.info.bufferSize > 0) {
                this.fos = new BufferedOutputStream(this.fos, this.info.bufferSize);
            }
            this.writer = new OutputStreamWriter(this.fos, StandardCharsets.UTF_8);
            this.writer.append('[');
        }

        @Override
        public void end() throws IOException {
            this.writer.append(']');
            this.writer.flush();
            this.fos.flush();
            this.fos.close();
        }

        @Override
        public synchronized void accept(SolrDocument doc) throws IOException {
            this.charArr.reset();
            LinkedHashMap m = CollectionUtil.newLinkedHashMap((int)doc.size());
            doc.forEach((s, field) -> {
                List list;
                if (s.equals("_version_") || s.equals("_roor_")) {
                    return;
                }
                if (field instanceof List && ((List)field).size() == 1) {
                    field = ((List)field).get(0);
                }
                if ((field = this.constructDateStr(field)) instanceof List && this.hasdate(list = (List)field)) {
                    ArrayList<Object> listCopy = new ArrayList<Object>(list.size());
                    for (Object o : list) {
                        listCopy.add(this.constructDateStr(o));
                    }
                    field = listCopy;
                }
                m.put(s, field);
            });
            if (this.firstDoc) {
                this.firstDoc = false;
            } else {
                this.writer.append(',');
            }
            this.jsonWriter.write((Map)m);
            this.writer.write(this.charArr.getArray(), this.charArr.getStart(), this.charArr.getEnd());
            this.writer.append('\n');
            super.accept(doc);
        }

        private boolean hasdate(List<?> list) {
            boolean hasDate = false;
            for (Object o : list) {
                if (!(o instanceof Date)) continue;
                hasDate = true;
                break;
            }
            return hasDate;
        }

        private Object constructDateStr(Object field) {
            if (field instanceof Date) {
                field = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Date)field).getTime()));
            }
            return field;
        }
    }

    static class JsonWithLinesSink
    extends DocsSink {
        private final CharArr charArr = new CharArr(2048);
        JSONWriter jsonWriter = new JSONWriter(this.charArr, -1);
        private Writer writer;

        public JsonWithLinesSink(Info info) {
            this.info = info;
        }

        @Override
        public void start() throws IOException {
            this.fos = new FileOutputStream(this.info.out);
            if (this.info.compress) {
                this.fos = new GZIPOutputStream(this.fos);
            }
            if (this.info.bufferSize > 0) {
                this.fos = new BufferedOutputStream(this.fos, this.info.bufferSize);
            }
            this.writer = new OutputStreamWriter(this.fos, StandardCharsets.UTF_8);
        }

        @Override
        public void end() throws IOException {
            this.writer.flush();
            this.fos.flush();
            this.fos.close();
        }

        @Override
        public synchronized void accept(SolrDocument doc) throws IOException {
            this.charArr.reset();
            LinkedHashMap m = CollectionUtil.newLinkedHashMap((int)doc.size());
            doc.forEach((s, field) -> {
                List list;
                if (s.equals("_version_") || s.equals("_roor_")) {
                    return;
                }
                if (field instanceof List && ((List)field).size() == 1) {
                    field = ((List)field).get(0);
                }
                if ((field = this.constructDateStr(field)) instanceof List && this.hasdate(list = (List)field)) {
                    ArrayList<Object> listCopy = new ArrayList<Object>(list.size());
                    for (Object o : list) {
                        listCopy.add(this.constructDateStr(o));
                    }
                    field = listCopy;
                }
                m.put(s, field);
            });
            this.jsonWriter.write((Map)m);
            this.writer.write(this.charArr.getArray(), this.charArr.getStart(), this.charArr.getEnd());
            this.writer.append('\n');
            super.accept(doc);
        }

        private boolean hasdate(List<?> list) {
            boolean hasDate = false;
            for (Object o : list) {
                if (!(o instanceof Date)) continue;
                hasDate = true;
                break;
            }
            return hasDate;
        }

        private Object constructDateStr(Object field) {
            if (field instanceof Date) {
                field = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Date)field).getTime()));
            }
            return field;
        }
    }

    static abstract class DocsSink {
        Info info;
        OutputStream fos;

        DocsSink() {
        }

        abstract void start() throws IOException;

        @SuppressForbidden(reason="Command line tool prints out to console")
        void accept(SolrDocument document) throws IOException {
            long count = this.info.docsWritten.incrementAndGet();
            if (count % 100000L == 0L) {
                System.out.println("\nDOCS: " + count);
            }
        }

        void end() throws IOException {
        }
    }

    public static abstract class Info {
        final ToolRuntime runtime;
        String baseurl;
        String format;
        boolean compress;
        String query;
        String coll;
        String out;
        String fields;
        long limit = 100L;
        AtomicLong docsWritten = new AtomicLong(0L);
        int bufferSize = 0x100000;
        String uniqueKey;
        CloudSolrClient solrClient;
        DocsSink sink;

        public Info(ToolRuntime runtime, String url) {
            this.runtime = runtime;
            this.setUrl(url);
            this.setOutFormat(null, "jsonl", false);
        }

        public void setUrl(String url) {
            int idx = url.lastIndexOf(47);
            this.baseurl = url.substring(0, idx);
            this.coll = url.substring(idx + 1);
            this.query = "*:*";
        }

        public void setLimit(String maxDocsStr) {
            this.limit = Long.parseLong(maxDocsStr);
            if (this.limit == -1L) {
                this.limit = Long.MAX_VALUE;
            }
        }

        public void setOutFormat(String out, String format, boolean compress) {
            this.compress = compress;
            this.format = format;
            this.out = out;
            if (this.format == null) {
                this.format = "json";
            }
            if (!formats.contains(this.format)) {
                throw new IllegalArgumentException("format must be one of: " + formats);
            }
            if (this.out == null) {
                this.out = this.coll;
            } else if (Files.isDirectory(Path.of(this.out, new String[0]), new LinkOption[0])) {
                this.out = this.out + "/" + this.coll;
            }
            this.out = this.out + "." + this.format;
            if (compress) {
                this.out = this.out + ".gz";
            }
        }

        DocsSink getSink() {
            DocsSink docSink = null;
            switch (this.format) {
                case "javabin": {
                    docSink = new JavabinSink(this);
                    break;
                }
                case "json": {
                    docSink = new JsonSink(this);
                    break;
                }
                case "jsonl": {
                    docSink = new JsonWithLinesSink(this);
                }
            }
            return docSink;
        }

        abstract void exportDocs() throws Exception;

        void fetchUniqueKey() throws SolrServerException, IOException {
            this.solrClient = new CloudHttp2SolrClient.Builder(Collections.singletonList(this.baseurl)).build();
            NamedList response = this.solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/schema/uniquekey", (SolrParams)new MapSolrParams(Collections.singletonMap("collection", this.coll))).setRequiresCollection(true));
            this.uniqueKey = (String)response.get("uniqueKey");
        }

        public static StreamingResponseCallback getStreamer(final Consumer<SolrDocument> sink) {
            return new StreamingResponseCallback(){

                public void streamSolrDocument(SolrDocument doc) {
                    try {
                        sink.accept(doc);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void streamDocListInfo(long numFound, long start, Float maxScore) {
                }
            };
        }
    }
}

