/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.apache.solr.common.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long bytesRead;
    private long markedBytesRead;
    private final Function<Long, InputStream> nextInputStreamSupplier;
    private InputStream delegate;

    public ResumableInputStream(InputStream delegate, Function<Long, InputStream> nextInputStreamSupplier) {
        this.delegate = delegate;
        this.nextInputStreamSupplier = nextInputStreamSupplier;
        this.bytesRead = 0L;
        this.markedBytesRead = 0L;
    }

    @Override
    public int read() throws IOException {
        return this.read(false);
    }

    public int read(boolean isRetry) throws IOException {
        int val;
        this.checkAndRefreshDelegate();
        try {
            val = this.delegate.read();
            if (val >= 0) {
                ++this.bytesRead;
            }
        }
        catch (IOException e) {
            if (isRetry) {
                throw e;
            }
            log.warn("Exception thrown while consuming InputStream, retrying from byte: {}", (Object)this.bytesRead, (Object)e);
            this.closeDelegate();
            val = this.read(true);
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, false);
    }

    public int read(byte[] b, int off, int len, boolean isRetry) throws IOException {
        int readLen;
        this.checkAndRefreshDelegate();
        try {
            readLen = this.delegate.read(b, off, len);
            if (readLen >= 0) {
                this.bytesRead += (long)readLen;
            }
        }
        catch (IOException e) {
            if (isRetry) {
                throw e;
            }
            log.warn("Exception thrown while consuming InputStream, retrying from byte: {}", (Object)this.bytesRead, (Object)e);
            this.closeDelegate();
            readLen = this.read(b, off, len, true);
        }
        return readLen;
    }

    @Override
    public long skip(long n) throws IOException {
        long skippedBytes;
        this.checkAndRefreshDelegate();
        try {
            skippedBytes = this.delegate.skip(n);
            this.bytesRead += skippedBytes;
        }
        catch (IOException e) {
            this.closeDelegate();
            this.bytesRead += n;
            log.warn("Exception thrown while skipping {} bytes in InputStream, resuming at byte: {}", new Object[]{n, this.bytesRead, e});
            this.checkAndRefreshDelegate();
            skippedBytes = n;
        }
        return skippedBytes;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markedBytesRead = this.bytesRead;
    }

    @Override
    public int available() throws IOException {
        this.checkAndRefreshDelegate();
        return this.delegate.available();
    }

    @Override
    public void reset() {
        this.bytesRead = this.markedBytesRead;
        this.closeDelegate();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private void closeDelegate() {
        IOUtils.closeQuietly(this.delegate);
        this.delegate = null;
    }

    private void checkAndRefreshDelegate() {
        if (this.delegate == null) {
            this.delegate = this.nextInputStreamSupplier.apply(this.bytesRead);
            if (this.delegate == null) {
                this.delegate = InputStream.nullInputStream();
            }
        }
    }
}

