-- |
-- Module      : SAD.ForTheL.Extension
-- Copyright   : (c) 2001 - 2008, Andrei Paskevich,
--               (c) 2017 - 2018, Steffen Frerix
-- License     : GPL-3
--
-- Language extensions.


{-# LANGUAGE OverloadedStrings #-}

module SAD.ForTheL.Extension (
  funVars,
  notionVars,
  prdVars,
  ignoreNames
) where

import Data.Text.Lazy (Text)
import Data.Text.Lazy qualified as Text

import SAD.Data.Formula
import SAD.ForTheL.Base
import SAD.Data.Text.Decl


-- well-formedness check

funVars, notionVars, prdVars :: (Formula, Formula) -> Maybe Text

funVars (f, d) | not ifq   = prdVars (f, d)
               | not idq   = Just $ Text.pack $ "illegal function alias: " ++ show d
               | otherwise = prdVars (t {trmArgs = v:trmArgs t}, d)
  where
    ifq = isTrm f && trmName f == TermEquality && isTrm t
    idq = isTrm d && trmName d == TermEquality && not (u `occursIn` p)
    Trm {trmName = TermEquality, trmArgs = [v, t]} = f
    Trm {trmName = TermEquality, trmArgs = [u, p]} = d


notionVars (f, d) | not isFunction = prdVars (f, d)
               | otherwise      = prdVars (t {trmArgs = v:vs}, d)
  where
    isFunction = isTrm f && trmName f == TermEquality && isTrm t
    Trm {trmName = TermEquality, trmArgs =  [v,t]} = f
    Trm {trmArgs = vs} = t


prdVars (f, d) | not flat  = Just $ Text.pack $ "compound expression: " ++ show f
               | otherwise = freeOrOverlapping (fvToVarSet $ free f) d
  where
    flat      = isTrm f && allDistinctVars (trmArgs f)


allDistinctVars :: [Formula] -> Bool
allDistinctVars = disVs []
  where
    disVs ls (Var {varName = v@(VarHidden _)} : vs) = notElem v ls && disVs (v:ls) vs
    disVs ls (Var {varName = v@(VarConstant _)} : vs) = notElem v ls && disVs (v:ls) vs
    disVs _ [] = True
    disVs _ _ = False

ignoreNames :: Formula -> Formula
ignoreNames (All dcl f) = All dcl {declName = VarEmpty} $ ignoreNames f
ignoreNames (Exi dcl f) = Exi dcl {declName = VarEmpty} $ ignoreNames f
ignoreNames f@Trm{}   = f
ignoreNames f         = mapF ignoreNames f
