/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.Output;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;

public abstract class Shell {
    public static final String SERVICE = "console.Shell";
    private String name;

    public Shell(String name) {
        this.name = name;
    }

    public static String[] getShellNames() {
        return ServiceManager.getServiceNames((String)SERVICE);
    }

    public boolean handlesVFS(String vfsPath) {
        return false;
    }

    public boolean chDir(Console console, String pathStr) {
        return false;
    }

    public static Shell getShell(String name) {
        return (Shell)ServiceManager.getService((String)SERVICE, (String)name);
    }

    public void openConsole(Console console) {
    }

    public void closeConsole(Console console) {
    }

    public void printInfoMessage(Output output) {
    }

    public void printPrompt(Console console, Output output) {
        String promptString = jEdit.getProperty((String)"console.prompt", (Object[])new String[]{this.getName()});
        output.print(console.getPlainColor(), "\n" + promptString);
    }

    public abstract void execute(Console var1, String var2, Output var3, Output var4, String var5);

    public final void execute(Console console, String command, Output output) {
        this.execute(console, null, output, null, command);
    }

    public void stop(Console console) {
    }

    public boolean waitFor(Console console) {
        return true;
    }

    public void endOfFile(Console console) {
    }

    public void detach(Console console) {
    }

    public CompletionInfo getCompletions(Console console, String command) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static class CompletionInfo {
        public int offset;
        public String[] completions;
    }

    public static class SwitchAction
    extends ShellAction {
        public SwitchAction(String shellName) {
            super("console.shell." + shellName + "-show", shellName);
        }

        public String getLabel() {
            return this.shellName;
        }

        public String getCode() {
            return "new console.Shell.SwitchAction(\"" + this.shellName + "\").invoke(view)";
        }

        @Override
        public void invoke(View view) {
            DockableWindowManager wm = view.getDockableWindowManager();
            wm.showDockableWindow("console");
            super.invoke(view);
        }
    }

    public static class ToggleAction
    extends ShellAction {
        public String getLabel() {
            return this.shellName + " (Toggle)";
        }

        public ToggleAction(String shellName) {
            super("console.shell." + shellName + "-toggle", shellName);
            this.shellName = shellName;
        }

        public String getCode() {
            return "new console.Shell.ToggleAction(\"" + this.shellName + "\").invoke(view)";
        }

        @Override
        public void invoke(View view) {
            super.invoke(view);
            jEdit.getAction((String)"console-toggle").invoke(view);
        }
    }

    public static abstract class ShellAction
    extends EditAction {
        protected String shellName;

        ShellAction(String actionName, String shellName) {
            super(actionName, new Object[]{shellName});
            this.shellName = shellName;
        }

        public void invoke(View view) {
            Console c = ConsolePlugin.getConsole(view);
            c.setShell(this.shellName);
        }
    }
}

