/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsoleProcess;
import console.Output;
import console.OutputThread;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ErrorThread
extends OutputThread {
    private ConsoleProcess process;
    private InputStream in;
    private boolean aborted;
    private Color errorColor;

    ErrorThread(ConsoleProcess process, InputStream in, Color errorColor) {
        this.process = process;
        this.in = in;
        this.errorColor = errorColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(this.in, jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        Output output = this.process.getErrorOutput();
        StringBuilder lineBuffer = new StringBuilder(100);
        try {
            char[] input = new char[1024];
            while (!this.aborted) {
                int read = isr.read(input, 0, input.length);
                if (this.aborted) {
                    break;
                }
                if (read == -1) {
                    if (lineBuffer.length() > 0) {
                        output.print(this.errorColor, lineBuffer.toString());
                    }
                    break;
                }
                output.print(this.errorColor, lineBuffer.append(input, 0, read).toString());
                lineBuffer.setLength(0);
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            if (!this.aborted) {
                if (this.process.isForeground()) {
                    Log.log((int)9, (Object)e, (Object)e);
                }
                Console console = this.process.getConsole();
                Output error = this.process.getErrorOutput();
                if (console != null) {
                    Object[] args = new String[]{e.toString()};
                    error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])args));
                }
            }
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException e2) {}
            this.process.threadDone();
        }
    }

    @Override
    void abort() {
        this.aborted = true;
        this.interrupt();
    }
}

