/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ErrorStreamTask;
import console.InputStreamTask;
import console.Output;
import console.OutputStreamTask;
import console.ProcessRunner;
import console.StreamTask;
import console.SystemShell;
import java.awt.Color;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;
import org.gjt.sp.util.Task;

class ConsoleProcessTask
extends Task {
    private Process process;
    private Console console;
    private SystemShell.ConsoleState consoleState;
    private String currentDirectory;
    private Output output;
    private Output error;
    private Output newError;
    private String[] args;
    private Map<String, String> env;
    private String input;
    private Thread currentThread;
    private InputStreamTask stdin;
    private OutputStreamTask stdout;
    private ErrorStreamTask stderr;
    private PipedOutputStream userInput;
    private int exitCode;
    private int failedStreamNumber;
    private boolean foreground;
    private boolean stopFlag;
    private boolean detachFlag;
    private int taskState;
    private Color errorColor;
    private Color plainColor;
    private Color infoColor;
    private final int DEFAULT_EXIT_CODE = 834;
    private final int MAX_CMDNAME_LENGTH = 12;
    private final char SYMBOL_BACKGROUND = (char)38;
    private final char SYMBOL_CLOSED_INPUT = (char)35;
    public static final int STATE_FAILURE = 1;
    public static final int STATE_WORKING = 2;
    public static final int STATE_FINISHED = 3;
    public static final int STATE_UPDATE = 4;

    private byte[] toBytes(String str) {
        try {
            return str.getBytes(jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            Log.log((int)9, ConsoleProcessTask.class, (Object)"toBytes()", (Throwable)e);
            return null;
        }
    }

    private void doDetach() throws InterruptedException, IOException {
        if (this.stdin != null) {
            this.stdin.abort();
        }
        if (this.stdout != null) {
            this.stdout.abort();
        }
        if (this.stdin != null) {
            this.stdin.join();
        }
        if (this.stdout != null) {
            this.stdout.join();
        }
        this.consoleState.setProcess(null);
        this.consoleState = null;
        this.error.print(this.errorColor, jEdit.getProperty((String)"console.shell.detached", (Object[])new Object[]{this.args[0]}));
        this.error.commandDone();
        this.output.commandDone();
        this.error = this.newError;
        this.output = null;
        this.foreground = false;
        this.detachFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop(boolean waitForStreams) {
        try {
            if (this.stdin != null) {
                this.stdin.abort();
            }
            if (waitForStreams) {
                if (this.stdout != null) {
                    this.stdout.finish();
                }
                if (this.stderr != null) {
                    this.stderr.finish();
                }
            } else {
                if (this.stdout != null) {
                    this.stdout.abort();
                }
                if (this.stderr != null) {
                    this.stderr.abort();
                }
            }
            if (this.stdout != null) {
                this.stdout.join();
            }
            if (this.stderr != null) {
                this.stderr.join();
            }
        }
        catch (Exception e) {
            Log.log((int)7, (Object)((Object)this), (Object)e.getMessage());
        }
        if (this.process != null) {
            try {
                this.process.destroy();
            }
            catch (Exception e) {
                Log.log((int)7, (Object)((Object)this), (Object)e.getMessage());
            }
            this.process = null;
        }
        ConsoleProcessTask e = this;
        synchronized (e) {
            this.stopFlag = true;
            ((Object)((Object)this)).notifyAll();
        }
        boolean showExitStatus = jEdit.getBooleanProperty((String)"console.processrunner.showExitStatus", (boolean)true);
        if (showExitStatus || !this.foreground) {
            String msg = jEdit.getProperty((String)"console.shell.exited", (Object[])new Object[]{this.args[0], this.exitCode});
            if (this.taskState == 3) {
                this.errorNotification(msg, this.infoColor);
            } else {
                this.errorNotification(msg);
            }
        }
        if (this.output != null) {
            this.output.commandDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCommandChannel() {
        try {
            try {
                if (this.userInput != null) {
                    this.userInput.close();
                }
            }
            finally {
                this.userInput = null;
                if (this.stdin != null) {
                    this.stdin.finish();
                }
                this.setTaskState(4);
            }
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)((Object)this), (Object)ioe);
        }
    }

    private void setTaskState(int newState) {
        int prevState = this.taskState;
        this.taskState = newState;
        int lastFileSep = this.args[0].lastIndexOf(System.getProperty("file.separator"));
        String cmdName = this.args[0].length() < 12 ? this.args[0] : (lastFileSep == -1 || lastFileSep >= this.args[0].length() ? this.args[0] : String.format("...%s%s", System.getProperty("file.separator"), this.args[0].substring(lastFileSep + 1)));
        String marks = (!this.foreground ? "& " : "") + (this.userInput == null ? "# " : "");
        this.setStatus(marks + cmdName);
        this.setLabel(StringList.join((Object[])this.args, (String)" "));
        if (this.taskState == 4) {
            this.taskState = prevState;
        }
    }

    ConsoleProcessTask(Console console, Output output, Output error, String[] args, Map<String, String> env2, SystemShell.ConsoleState consoleState, boolean foreground, String input) {
        this.args = args;
        this.currentDirectory = consoleState.currentDirectory;
        this.env = env2;
        this.input = input;
        this.foreground = foreground;
        this.console = console;
        this.error = error;
        this.errorColor = console.getErrorColor();
        this.plainColor = console.getPlainColor();
        this.infoColor = console.getInfoColor();
        if (foreground) {
            this.output = output;
            this.consoleState = consoleState;
            this.userInput = new PipedOutputStream();
            this.failedStreamNumber = 3;
        } else {
            this.failedStreamNumber = 1;
        }
        this.currentThread = Thread.currentThread();
        this.exitCode = 834;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _run() {
        try {
            boolean waitForStreams = true;
            try {
                boolean merge = jEdit.getBooleanProperty((String)"console.processrunner.mergeError", (boolean)true);
                try {
                    this.process = ProcessRunner.getProcessRunner().exec(this.args, this.env, this.currentDirectory, merge && this.foreground);
                }
                catch (IOException ioe) {
                    waitForStreams = false;
                    String msg = "unrecognized command: " + StringList.join((Object[])this.args, (String)" ");
                    this.errorNotification(msg);
                    throw new Exception(msg, ioe);
                }
                this.setTaskState(2);
                if (this.foreground) {
                    if (merge) {
                        --this.failedStreamNumber;
                    } else {
                        this.stderr = new ErrorStreamTask(this, this.process.getErrorStream(), this.error, this.errorColor);
                    }
                    this.stdout = new OutputStreamTask(this, this.process.getInputStream(), this.output, this.plainColor, this.console, this.currentDirectory);
                    this.stdin = new InputStreamTask(this, this.process.getOutputStream(), this.userInput);
                    if (!merge) {
                        this.stderr.start();
                    }
                    this.stdout.start();
                    this.stdin.start();
                } else {
                    this.stderr = new ErrorStreamTask(this, this.process.getErrorStream(), this.error, this.errorColor);
                    this.stderr.start();
                }
                try {
                    ConsoleProcessTask ioe = this;
                    synchronized (ioe) {
                        for (int attempt = 0; attempt < 10 && this.failedStreamNumber > 0; ++attempt) {
                            ((Object)((Object)this)).wait(10L);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    waitForStreams = false;
                }
                if (this.failedStreamNumber != 0) {
                    waitForStreams = false;
                    throw new Exception("Some child thread has not started");
                }
                if (this.input != null) {
                    this.sendCommand(this.input);
                }
                boolean working = true;
                do {
                    try {
                        this.exitCode = this.process.exitValue();
                        working = false;
                    }
                    catch (IllegalThreadStateException itse) {
                        working = true;
                    }
                    if (!(working &= !this.currentThread.isInterrupted() && !this.stopFlag)) continue;
                    if (this.detachFlag && this.foreground) {
                        this.doDetach();
                        this.setTaskState(4);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        waitForStreams = false;
                        throw new Exception(ie.toString(), ie);
                    }
                } while (working);
                waitForStreams &= !this.currentThread.isInterrupted() && !this.stopFlag;
            }
            finally {
                this.doStop(waitForStreams);
            }
            this.setTaskState(3);
        }
        catch (Exception e) {
            String msg = jEdit.getProperty((String)"console.shell.error", (Object[])new Object[]{e.getMessage()});
            Log.log((int)9, (Object)((Object)this), (Object)msg);
            this.errorNotification(msg);
            this.setTaskState(1);
        }
    }

    public synchronized void streamStart(StreamTask stream) {
        if (stream == null) {
            return;
        }
        --this.failedStreamNumber;
        ((Object)((Object)this)).notifyAll();
    }

    public void streamFinish(StreamTask stream) {
        if (stream == null) {
            return;
        }
        if (stream == this.stderr) {
            this.stderr = null;
        }
        if (stream == this.stdout) {
            this.stdout = null;
        }
        if (stream == this.stdin) {
            this.stdin = null;
            this.closeCommandChannel();
        }
    }

    boolean detach(Output newErrorOutput) {
        this.newError = newErrorOutput;
        this.detachFlag = newErrorOutput != null;
        return this.detachFlag;
    }

    void stop() {
        this.stopFlag = true;
    }

    public void cancel() {
        this.stop();
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.stopFlag) {
            ((Object)((Object)this)).wait(100L);
        }
        return this.exitCode;
    }

    boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            return true;
        }
        return false;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    int getExitStatus() {
        return this.exitCode;
    }

    Console getConsole() {
        return this.console;
    }

    Output getOutput() {
        return this.output;
    }

    Output getErrorOutput() {
        return this.error;
    }

    String getCurrentDirectory() {
        return this.currentDirectory;
    }

    String[] getArgs() {
        String[] result = new String[this.args.length];
        System.arraycopy(this.args, 0, result, 0, this.args.length);
        return result;
    }

    int getTaskState() {
        return this.taskState;
    }

    public boolean sendCommand(String command) {
        if (this.userInput != null && command != null) {
            try {
                this.userInput.write(this.toBytes(command));
                this.userInput.flush();
                return true;
            }
            catch (IOException e) {
                Log.log((int)9, (Object)((Object)this), (Object)e);
                Log.log((int)9, (Object)((Object)this), (Object)("'" + command + "'"));
            }
        }
        return false;
    }

    public void endOfFile() {
        this.closeCommandChannel();
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)((Object)this), (Object)ioe);
        }
    }

    public void errorNotification(Exception e) {
        this.errorNotification(e.toString());
    }

    public void errorNotification(String s) {
        this.errorNotification(s, this.errorColor);
    }

    public void errorNotification(String s, Color color) {
        this.error.print(color, s);
    }
}

