/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.BufferOutput;
import console.ConsolePane;
import console.Output;
import console.ProcessRunner;
import console.ProjectTreeListener;
import console.Shell;
import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.StyleConstants;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AnimatedIcon;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSPathSelected;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class Console
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    private static final Icon RUN_AGAIN = GUIUtilities.loadIcon((String)"RunAgain.png");
    private static final Icon RUN = GUIUtilities.loadIcon((String)"Run.png");
    private static final Icon TO_BUFFER = GUIUtilities.loadIcon((String)"RunToBuffer.png");
    private static final Icon STOP = GUIUtilities.loadIcon((String)"Cancel.png");
    private static final Icon CLEAR = GUIUtilities.loadIcon((String)"Clear.png");
    private View view;
    private Map<String, ShellState> shellStateMap;
    private Shell currentShell;
    private ShellState shellState;
    private JComboBox shellCombo;
    private RolloverButton runAgain;
    private RolloverButton run;
    private RolloverButton toBuffer;
    private RolloverButton stop;
    private RolloverButton clear;
    private JLabel animationLabel;
    private AnimatedIcon animation;
    private ConsolePane text;
    private Color infoColor;
    private Color warningColor;
    private Color errorColor;
    private Color plainColor;
    private DefaultErrorSource errorSource;
    private ProjectTreeListener listener;
    private static final long serialVersionUID = -9185531673809120587L;

    public Console(View view) {
        super(new BorderLayout());
        Shell s;
        this.view = view;
        this.shellStateMap = new HashMap<String, ShellState>();
        this.initGUI();
        this.propertiesChanged();
        String defShell = jEdit.getProperty((String)"console.shell.default", (String)"System");
        if (defShell.equals(jEdit.getProperty((String)"options.last-selected"))) {
            defShell = jEdit.getProperty((String)"console.shell", (String)"System");
        }
        if ((s = Shell.getShell(defShell)) == null) {
            s = Shell.getShell("System");
        }
        this.setShell(s);
        this.load();
        this.propertiesChanged();
    }

    public void focusOnDefaultComponent() {
        this.text.requestFocus();
    }

    public void load() {
        EditBus.addToBus((EBComponent)this);
        this.addProjectListener();
        this.errorSource = new DefaultErrorSource("error parsing", this.view);
    }

    void addProjectListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new ProjectTreeListener(this);
    }

    public void unload() {
        EditBus.removeFromBus((EBComponent)this);
        if (this.listener != null) {
            EditBus.removeFromBus((EBComponent)this.listener);
            this.listener.finalize();
        }
        ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
        for (ShellState state : this.shellStateMap.values()) {
            state.shell.closeConsole(this);
        }
        this.shellStateMap.clear();
        this.view = null;
        this.text = null;
        this.shellState = null;
        this.animation.stop();
    }

    public View getView() {
        return this.view;
    }

    public Shell getShell() {
        String shellName = (String)this.shellCombo.getSelectedItem();
        return Shell.getShell(shellName);
    }

    public Shell setShell(String shellStr) {
        Shell shell = Shell.getShell(shellStr);
        if (shell == null) {
            throw new RuntimeException("Unknown Shell: " + shellStr);
        }
        return this.setShell(shell);
    }

    public Shell setShell(Shell shell) {
        if (shell == null) {
            return null;
        }
        String name = shell.getName();
        String shellHistory = this.getShellHistory(shell);
        String limit = jEdit.getProperty((String)"console.historyLimit");
        if (limit != null) {
            try {
                HistoryModel.getModel((String)shellHistory).setMax(Integer.parseInt(limit));
            }
            catch (NumberFormatException nfe) {
                jEdit.unsetProperty((String)"console.historyLimit");
            }
        }
        this.text.setHistoryModel(shellHistory);
        this.shellState = this.shellStateMap.get(name);
        if (this.shellState == null) {
            this.shellState = new ShellState(shell);
            this.shellStateMap.put(shell.getName(), this.shellState);
            shell.printInfoMessage(this.shellState);
            shell.printPrompt(this, this.shellState);
        }
        jEdit.setProperty((String)"console.shell", (String)name);
        this.text.setDocument(this.shellState.scrollback);
        if (shell != this.currentShell) {
            this.shellCombo.setSelectedItem(name);
        }
        this.currentShell = shell;
        this.scrollToBottom();
        return shell;
    }

    public void scrollToBottom() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Console.this.text.setCaretPosition(Console.this.text.getDocument().getLength());
                Console.this.text.scrollRectToVisible(Console.this.text.getVisibleRect());
                Console.this.updateAnimation();
            }
        });
    }

    public ConsolePane getConsolePane() {
        return this.text;
    }

    public JTextPane getOutputPane() {
        return this.text;
    }

    public void clear() {
        this.text.setText("");
        this.getShell().printInfoMessage(this.shellState);
    }

    public Output getOutput(String shellName) {
        ShellState retval = this.shellStateMap.get(shellName);
        if (retval == null) {
            Shell s = Shell.getShell(shellName);
            retval = new ShellState(s);
            this.shellStateMap.put(shellName, retval);
        }
        return retval;
    }

    public Output getOutput() {
        return this.shellState;
    }

    public void runLastCommand() {
        HistoryModel history = this.text.getHistoryModel();
        if (history.getSize() == 0) {
            this.getToolkit().beep();
            return;
        }
        this.run(this.getShell(), null, this.getOutput(), null, history.getItem(0));
    }

    public void handleMessage(EBMessage msg) {
        DockableWindowUpdate dwu;
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof DockableWindowUpdate && (dwu = (DockableWindowUpdate)msg).getWhat() != null && dwu.getWhat().equals(DockableWindowUpdate.ACTIVATED) && dwu.getDockable().equals("console")) {
            this.scrollToBottom();
        }
        String dir = "";
        try {
            dir = this.view.getEditPane().getBuffer().getDirectory();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (!dir.isEmpty() && (dir.startsWith("sftp://") || jEdit.getBooleanProperty((String)"console.changedir.followTextArea"))) {
            ViewUpdate vu;
            BufferUpdate bmsg;
            EditPaneUpdate epu;
            boolean chdir = false;
            if (msg instanceof EditPaneUpdate && (epu = (EditPaneUpdate)msg).getWhat() == EditPaneUpdate.BUFFER_CHANGED && epu.getEditPane().getView() == this.view) {
                chdir = true;
            }
            if (msg instanceof BufferUpdate && (bmsg = (BufferUpdate)msg).getWhat() == BufferUpdate.LOADED && bmsg.getView() == this.view) {
                chdir = true;
            }
            if (msg instanceof ViewUpdate && (vu = (ViewUpdate)msg).getWhat() == ViewUpdate.EDIT_PANE_CHANGED && vu.getView() == this.view) {
                chdir = true;
            }
            if (chdir) {
                this.chDir(dir);
            }
        }
        if (msg instanceof PluginUpdate) {
            this.handlePluginUpdate((PluginUpdate)msg);
        } else if (msg instanceof VFSPathSelected) {
            this.handleNodeSelected((VFSPathSelected)msg);
        } else if (msg instanceof ViewUpdate) {
            this.handleViewUpdate((ViewUpdate)msg);
        } else if (this.listener != null) {
            this.listener.handleMessage(msg);
        }
    }

    private void handleViewUpdate(ViewUpdate vu) {
        if (vu.getWhat() == ViewUpdate.CLOSED && vu.getView() == this.view) {
            this.unload();
        }
    }

    public DefaultErrorSource getErrorSource() {
        return this.errorSource;
    }

    public Color getInfoColor() {
        return this.infoColor;
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public Color getPlainColor() {
        return this.plainColor;
    }

    public int getId() {
        int retval = 0;
        for (View v = jEdit.getFirstView(); v != null; v = v.getNext()) {
            if (v == this.view) {
                return retval;
            }
            ++retval;
        }
        return -1;
    }

    public void print(Color color, String msg) {
        this.getOutput().print(color, msg);
    }

    public void writeAttrs(AttributeSet attrs, String msg) {
        this.getOutput().writeAttrs(attrs, msg);
    }

    public void commandDone() {
        this.getOutput().commandDone();
    }

    public ShellState getShellState(Shell shell) {
        return this.shellStateMap.get(shell.getName());
    }

    public void stopAnimation() {
        this.shellState.commandRunning = false;
        this.animation.stop();
    }

    public void startAnimation() {
        this.currentShell = this.getShell();
        this.shellState = this.getShellState(this.currentShell);
        this.shellState.commandRunning = true;
        this.animationLabel.setVisible(true);
        this.animation.start();
    }

    public void run(Shell shell, String input, Output output, Output error, String cmd) {
        this.run(shell, input, output, error, cmd, true);
    }

    public void run(Shell shell, String command) {
        this.run(shell, null, null, null, command);
    }

    public void run(Shell shell, Output output, String command) {
        this.run(shell, null, output, null, command);
    }

    private void run(Shell shell, String input, Output output, Output error, String cmd, boolean printInput) {
        Shell _shell;
        if (cmd.length() != 0) {
            HistoryModel.getModel((String)this.getShellHistory(shell)).addItem(cmd);
        }
        this.text.setHistoryIndex(-1);
        if (cmd.startsWith(":") && (_shell = Shell.getShell(cmd.substring(1))) != null) {
            this.text.setInput(null);
            this.setShell(_shell);
            return;
        }
        this.setShell(shell);
        if (output == null) {
            output = this.getOutput();
        }
        if (error == null) {
            error = this.getOutput();
        }
        this.text.setCaretPosition(this.text.getDocument().getLength());
        ShellState state = this.getShellState(shell);
        state.commandRunning = true;
        this.updateAnimation();
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            if (output instanceof BufferOutput) {
                error = state;
                recorder.record("runCommandToBuffer(view,\"" + shell.getName() + "\",\"" + StandardUtilities.charsToEscapes((String)cmd) + "\");");
            } else {
                recorder.record("runCommandInConsole(view,\"" + shell.getName() + "\",\"" + StandardUtilities.charsToEscapes((String)cmd) + "\");");
            }
        }
        if (printInput) {
            error.print(this.infoColor, cmd);
        } else {
            error.print(null, "");
        }
        this.errorSource.clear();
        ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
        try {
            shell.execute(this, input, output, error, cmd);
            this.startAnimation();
        }
        catch (RuntimeException e) {
            this.print(this.getErrorColor(), e.toString());
            Log.log((int)9, (Object)this, (Object)e);
            output.commandDone();
        }
    }

    private void initGUI() {
        Box box = new Box(0);
        this.shellCombo = new JComboBox();
        this.updateShellList();
        this.shellCombo.addActionListener(new ActionHandler());
        this.shellCombo.setRequestFocusEnabled(false);
        box.add(this.shellCombo);
        box.add(Box.createGlue());
        this.animationLabel = new JLabel();
        this.animationLabel.setBorder(new EmptyBorder(2, 3, 2, 3));
        this.initAnimation();
        this.animationLabel.setIcon((Icon)this.animation);
        this.animationLabel.setVisible(false);
        this.animation.stop();
        box.add(this.animationLabel);
        this.runAgain = new RolloverButton(RUN_AGAIN);
        box.add((Component)this.runAgain);
        this.runAgain.setToolTipText(jEdit.getProperty((String)"run-last-console-command.label"));
        Insets margin = new Insets(0, 0, 0, 0);
        this.runAgain.setMargin(margin);
        this.runAgain.addActionListener((ActionListener)new ActionHandler());
        this.runAgain.setRequestFocusEnabled(false);
        this.run = new RolloverButton(RUN);
        box.add((Component)this.run);
        this.run.setToolTipText(jEdit.getProperty((String)"console.run"));
        margin = new Insets(0, 0, 0, 0);
        this.run.setMargin(margin);
        this.run.addActionListener((ActionListener)new RunActionHandler());
        this.run.setRequestFocusEnabled(false);
        this.toBuffer = new RolloverButton(TO_BUFFER);
        box.add((Component)this.toBuffer);
        this.toBuffer.setToolTipText(jEdit.getProperty((String)"console.to-buffer"));
        this.toBuffer.setMargin(margin);
        this.toBuffer.addActionListener((ActionListener)new RunActionHandler());
        this.toBuffer.setRequestFocusEnabled(false);
        this.stop = new RolloverButton(STOP);
        box.add((Component)this.stop);
        this.stop.setToolTipText(jEdit.getProperty((String)"console.stop"));
        this.stop.setMargin(margin);
        this.stop.addActionListener((ActionListener)new ActionHandler());
        this.stop.setRequestFocusEnabled(false);
        this.clear = new RolloverButton(CLEAR);
        box.add((Component)this.clear);
        this.clear.setToolTipText(jEdit.getProperty((String)"console.clear"));
        this.clear.setMargin(margin);
        this.clear.addActionListener((ActionListener)new ActionHandler());
        this.clear.setRequestFocusEnabled(false);
        this.add("North", box);
        this.text = new ConsolePane();
        InputMap inputMap = this.text.getInputMap();
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2);
        inputMap.put(ctrlEnter, new RunToBuffer());
        inputMap.put(KeyStroke.getKeyStroke(9, 0), new CompletionAction());
        inputMap.put(KeyStroke.getKeyStroke(68, 2), new EOFAction());
        inputMap.put(KeyStroke.getKeyStroke(90, 2), new DetachAction());
        this.text.addActionListener(new RunActionHandler());
        JScrollPane scroller = new JScrollPane(this.text);
        scroller.setPreferredSize(new Dimension(400, 100));
        this.add("Center", scroller);
    }

    private void initAnimation() {
        Toolkit toolkit = this.getToolkit();
        Image processImg = toolkit.getImage(Console.class.getResource("/console/process-working.png"));
        BufferedImage standbyImg = null;
        int iconSize = 22;
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        new ImageIcon(processImg).getImage();
        int procImgWidth = processImg.getWidth(null);
        int procImgHeight = processImg.getHeight(null);
        int currentX = 0;
        int currentY = 0;
        int frameNo = 0;
        while (currentY < procImgHeight) {
            BufferedImage bufImg = new BufferedImage(iconSize, iconSize, 2);
            Graphics2D bufGraphics = bufImg.createGraphics();
            bufGraphics.drawImage(processImg, 0, 0, iconSize - 1, iconSize - 1, currentX, currentY, currentX + iconSize - 1, currentY + iconSize - 1, null);
            if (frameNo == 0) {
                standbyImg = bufImg;
            } else {
                frames.add(bufImg);
            }
            ++frameNo;
            if ((currentX += iconSize) + iconSize <= procImgWidth) continue;
            currentX = 0;
            currentY += iconSize;
        }
        this.animation = new AnimatedIcon(standbyImg, frames.toArray(new Image[0]), 25, (Component)this.animationLabel);
    }

    private void updateShellList() {
        String[] shells = Shell.getShellNames();
        Arrays.sort(shells, new StandardUtilities.StringCompare(true));
        this.shellCombo.setModel(new DefaultComboBoxModel<String>(shells));
        this.shellCombo.setMaximumSize(this.shellCombo.getPreferredSize());
    }

    private void propertiesChanged() {
        if (jEdit.getBooleanProperty((String)"textColors")) {
            this.plainColor = jEdit.getColorProperty((String)"view.fgColor", (Color)Color.BLACK);
            this.text.setBackground(jEdit.getColorProperty((String)"view.bgColor", (Color)Color.WHITE));
            this.text.setCaretColor(jEdit.getColorProperty((String)"view.caretColor", (Color)this.plainColor));
        } else {
            this.plainColor = jEdit.getColorProperty((String)"console.plainColor", (Color)Color.BLACK);
            this.text.setBackground(jEdit.getColorProperty((String)"console.bgColor", (Color)Color.WHITE));
            this.text.setCaretColor(jEdit.getColorProperty((String)"console.caretColor", (Color)this.plainColor));
        }
        this.text.setForeground(this.plainColor);
        this.text.setFont(jEdit.getFontProperty((String)"console.font"));
        this.infoColor = jEdit.getColorProperty((String)"console.infoColor");
        this.warningColor = jEdit.getColorProperty((String)"console.warningColor");
        this.errorColor = jEdit.getColorProperty((String)"console.errorColor");
    }

    public boolean chDir(String path, boolean selectShell) {
        if (!this.isVisible()) {
            return false;
        }
        if (selectShell) {
            String name = Console.shellForVFS(path);
            Shell s = Shell.getShell(name);
            this.setShell(s);
        }
        return this.getShell().chDir(this, path);
    }

    public boolean chDir(String path) {
        return this.chDir(path, false);
    }

    public static String shellForVFS(String path) {
        for (String name : Shell.getShellNames()) {
            Shell s = Shell.getShell(name);
            if (!s.handlesVFS(path)) continue;
            return name;
        }
        return "System";
    }

    public void handleNodeSelected(VFSPathSelected msg) {
        if (this.view != msg.getView()) {
            return;
        }
        String path = msg.getPath();
        if (!msg.isDirectory()) {
            path = MiscUtilities.getParentOfPath((String)path);
        }
        if (jEdit.getBooleanProperty((String)"console.changedir.nodeselect")) {
            this.chDir(path);
        }
    }

    public void handlePluginUpdate(PluginUpdate pmsg) {
        if (pmsg.getWhat() == PluginUpdate.LOADED || pmsg.getWhat() == PluginUpdate.UNLOADED) {
            boolean resetShell = false;
            this.updateShellList();
            Iterator<String> iter = this.shellStateMap.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                if (Shell.getShell(name) != null) continue;
                if (this.currentShell.getName().equals(name)) {
                    resetShell = true;
                }
                iter.remove();
            }
            if (resetShell) {
                this.setShell(this.shellStateMap.keySet().iterator().next());
            } else {
                this.shellCombo.setSelectedItem(this.currentShell.getName());
            }
        }
    }

    public void updateAnimation() {
        if (this.shellState.commandRunning) {
            this.animationLabel.setVisible(true);
            this.animation.start();
        } else {
            this.animationLabel.setVisible(false);
            this.animation.stop();
        }
    }

    private void complete() {
        String input = this.text.getInput();
        int cmdStart = this.text.getInputStart();
        int caret = this.text.getCaretPosition();
        int offset = caret - cmdStart;
        Shell.CompletionInfo info = this.currentShell.getCompletions(this, input.substring(0, offset));
        if (info == null || info.completions.length == 0) {
            this.getToolkit().beep();
        } else if (info.completions.length == 1) {
            this.text.select(cmdStart + info.offset, caret);
            this.text.replaceSelection(info.completions[0]);
        } else {
            String longestCommonStart = MiscUtilities.getLongestPrefix((String[])info.completions, (boolean)ProcessRunner.getProcessRunner().isCaseSensitive());
            if (longestCommonStart.length() != 0 && offset - info.offset != longestCommonStart.length()) {
                this.text.select(cmdStart + info.offset, caret);
                this.text.replaceSelection(longestCommonStart);
                return;
            }
            this.getOutput().print(null, "");
            this.getOutput().print(this.getInfoColor(), jEdit.getProperty((String)"console.completions"));
            Arrays.sort(info.completions, new StandardUtilities.StringCompare(true));
            for (int i = 0; i < info.completions.length; ++i) {
                this.print(null, info.completions[i]);
            }
            this.getOutput().print(this.getInfoColor(), jEdit.getProperty((String)"console.completions-end"));
            this.currentShell.printPrompt(this, this.shellState);
            cmdStart = this.text.getDocument().getLength();
            this.getOutput().writeAttrs(null, input);
            int lengthLimit = jEdit.getIntegerProperty((String)"console.outputLimit", (int)80000);
            if (cmdStart + input.length() > lengthLimit) {
                cmdStart = lengthLimit - input.length() + 1;
            }
            this.text.setInputStart(cmdStart);
            this.text.setCaretPosition(cmdStart + offset);
        }
    }

    private String getShellHistory(Shell shell) {
        return "console." + shell.getName();
    }

    class DetachAction
    extends AbstractAction {
        DetachAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Console.this.currentShell.detach(Console.this);
        }
    }

    class EOFAction
    extends AbstractAction {
        EOFAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Console.this.currentShell.endOfFile(Console.this);
        }
    }

    class CompletionAction
    extends AbstractAction {
        CompletionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Console.this.complete();
        }
    }

    class RunToBuffer
    extends AbstractAction {
        RunToBuffer() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String cmd = Console.this.text.getInput();
            BufferOutput output = new BufferOutput(Console.this, BufferOutput.guessMode(cmd));
            Console.this.run(Console.this.getShell(), null, output, Console.this.shellState, cmd, false);
        }
    }

    class RunActionHandler
    implements ActionListener {
        RunActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String cmd = Console.this.text.getInput();
            Object source = evt.getSource();
            String input = Console.this.view.getTextArea().getSelectedText();
            Output output = Console.this.shellState;
            boolean printInput = false;
            if (source == Console.this.run) {
                printInput = true;
            } else if (source == Console.this.toBuffer) {
                output = new BufferOutput(Console.this, BufferOutput.guessMode(cmd));
            }
            Console.this.run(Console.this.getShell(), input, output, Console.this.shellState, cmd, printInput);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == Console.this.shellCombo) {
                Console.this.setShell((String)Console.this.shellCombo.getSelectedItem());
            } else if (source == Console.this.runAgain) {
                Console.this.runLastCommand();
            } else if (source == Console.this.stop) {
                Console.this.getShell().stop(Console.this);
            } else if (source == Console.this.clear) {
                Console.this.clear();
                Console.this.getShell().printPrompt(Console.this, Console.this.shellState);
            }
        }
    }

    public static class EvalAction
    extends AbstractAction {
        private String command;

        public EvalAction(String label, String command) {
            super(label);
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Console console = (Console)GUIUtilities.getComponentParent((Component)((Component)evt.getSource()), Console.class);
            console.run(console.getShell(), null, console.getOutput(), null, this.command);
        }
    }

    private class LengthFilter
    extends DocumentFilter {
        public static final int DEFAULT_LIMIT = 80000;

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet attr) throws BadLocationException {
            this.replace(fb, offset, 0, str, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet attrs) throws BadLocationException {
            int newLength = fb.getDocument().getLength() - length + str.length();
            fb.replace(offset, length, str, attrs);
            int limit = jEdit.getIntegerProperty((String)"console.outputLimit", (int)80000);
            if (newLength > limit) {
                fb.remove(0, newLength - limit - 1);
            }
        }
    }

    public class ShellState
    implements Output {
        Shell shell;
        Document scrollback;
        private boolean commandRunning;

        public Document getDocument() {
            return this.scrollback;
        }

        public ShellState(Shell shell) {
            this.shell = shell;
            this.commandRunning = false;
            this.scrollback = new DefaultStyledDocument();
            ((DefaultStyledDocument)this.scrollback).setDocumentFilter(new LengthFilter());
            shell.openConsole(Console.this);
        }

        public int getInputStart() {
            return (Integer)this.scrollback.getProperty("InputStart");
        }

        public void setInputStart(int cmdStart) {
            this.scrollback.putProperty("InputStart", cmdStart);
        }

        @Override
        public void print(Color color, String msg) {
            this.writeAttrs(ConsolePane.colorAttributes(color), msg + "\n");
        }

        @Override
        public void writeAttrs(final AttributeSet attrs, final String msg) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.writeSafely(attrs, msg);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShellState.this.writeSafely(attrs, msg);
                    }
                });
            }
        }

        @Override
        public void setAttrs(final int length, final AttributeSet attrs) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setSafely(this.scrollback.getLength() - length, length, attrs);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShellState.this.setSafely(ShellState.this.scrollback.getLength() - length, length, attrs);
                    }
                });
            }
        }

        private void setSafely(int start, int length, AttributeSet attrs) {
            ((DefaultStyledDocument)this.scrollback).setCharacterAttributes(start, length, attrs, true);
        }

        @Override
        public void commandDone() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShellState.this.commandRunning) {
                        ShellState.this.shell.printPrompt(Console.this, ShellState.this);
                    }
                    ShellState.this.commandRunning = false;
                    Console.this.stopAnimation();
                    if (Console.this.errorSource.getErrorCount() != 0) {
                        ErrorSource.registerErrorSource((ErrorSource)Console.this.errorSource);
                    }
                }
            });
        }

        private void writeSafely(AttributeSet attrs, String msg) {
            try {
                if (attrs != null && StyleConstants.getIcon(attrs) != null) {
                    msg = " ";
                }
                this.scrollback.insertString(this.scrollback.getLength(), msg, attrs);
            }
            catch (BadLocationException bl) {
                Log.log((int)9, (Object)this, (Object)bl);
            }
            this.setInputStart(this.scrollback.getLength());
        }
    }
}

