/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private final LinkedHashMap<String, Mode> modes = new LinkedHashMap(250);

    public void removeAll() {
        this.modes.clear();
    }

    public boolean removeMode(String name) throws IOException {
        Mode mode = this.modes.get(name);
        if (mode.isUserMode()) {
            File catalogFile;
            Mode oldMode = (Mode)this.modes.remove(name);
            if (oldMode == null) {
                return false;
            }
            String modeFilename = (String)mode.getProperty("file");
            File modeFile = new File(modeFilename);
            if (modeFile.exists()) {
                Path path = FileSystems.getDefault().getPath(modeFilename, new String[0]);
                Files.move(path, path.resolveSibling(modeFilename + "_unused"), StandardCopyOption.REPLACE_EXISTING);
            }
            if ((catalogFile = new File(modeFile.getParent(), "catalog")).exists()) {
                StringBuilder contents = new StringBuilder();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(catalogFile));
                    while ((line = br.readLine()) != null) {
                        contents.append(line).append('\n');
                    }
                    br.close();
                }
                catch (IOException ioe) {
                    this.modes.put(oldMode.getName(), oldMode);
                    throw ioe;
                }
                if (contents.length() == 0) {
                    this.modes.put(oldMode.getName(), oldMode);
                    return false;
                }
                Pattern p = Pattern.compile("(?m)(^\\s*[<]MODE.*?NAME=\"" + name + "\".*?[>])");
                Matcher m = p.matcher(contents);
                String newContents = m.replaceFirst("<!--$1-->");
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(catalogFile));
                    bw.write(newContents, 0, newContents.length());
                    bw.flush();
                    bw.close();
                }
                catch (IOException ioe) {
                    this.modes.put(oldMode.getName(), oldMode);
                    throw ioe;
                }
            }
        }
        return true;
    }

    public Mode getMode(String name) {
        return this.modes.get(name);
    }

    public Mode getModeForFile(String filename, String firstLine) {
        return this.getModeForFile(null, filename, firstLine);
    }

    /*
     * WARNING - void declaration
     */
    public Mode getModeForFile(String filepath, String filename, String firstLine) {
        if (filepath != null && filepath.endsWith(".gz")) {
            filepath = filepath.substring(0, filepath.length() - 3);
        }
        if (filename != null && filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        ArrayList<Mode> acceptable = new ArrayList<Mode>(1);
        for (Mode mode : this.modes.values()) {
            if (!mode.accept(filepath, filename, firstLine)) continue;
            acceptable.add(mode);
        }
        if (acceptable.size() == 1) {
            return (Mode)acceptable.get(0);
        }
        if (acceptable.size() > 1) {
            Collections.reverse(acceptable);
            for (Mode mode : acceptable) {
                if (!mode.acceptIdentical(filepath, filename)) continue;
                return mode;
            }
            for (Mode mode : acceptable) {
                if (!mode.acceptFile(filepath, filename) || !mode.acceptFirstLine(firstLine)) continue;
                return mode;
            }
            ArrayList<Mode> filepathMatch = new ArrayList<Mode>();
            for (Mode mode : acceptable) {
                if (!mode.acceptFile(filepath, filename)) continue;
                filepathMatch.add(mode);
            }
            if (filepathMatch.size() == 1) {
                return (Mode)filepathMatch.get(0);
            }
            if (filepathMatch.size() > 1) {
                void var6_13;
                Mode mode = (Mode)filepathMatch.get(0);
                for (Mode mode2 : filepathMatch) {
                    if (((String)mode2.getProperty("filenameGlob")).length() <= ((String)var6_13.getProperty("filenameGlob")).length()) continue;
                    Mode mode3 = mode2;
                }
                return var6_13;
            }
            return (Mode)acceptable.get(0);
        }
        return null;
    }

    public Mode[] getModes() {
        return this.modes.values().toArray(new Mode[0]);
    }

    public void addMode(Mode mode) {
        String name = mode.getName();
        this.modes.remove(name);
        this.modes.put(name, mode);
    }

    public void addUserMode(Mode mode, Path target) throws IOException {
        mode.setUserMode(true);
        String name = mode.getName();
        String modeFile = (String)mode.getProperty("file");
        String filenameGlob = (String)mode.getProperty("filenameGlob");
        String firstLineGlob = (String)mode.getProperty("firstlineGlob");
        Path source = FileSystems.getDefault().getPath(modeFile, new String[0]);
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        File catalogFile = new File(target.toFile().getParent(), "catalog");
        if (catalogFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(catalogFile));
                StringBuilder contents = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    contents.append(line).append('\n');
                }
                br.close();
                Pattern p = Pattern.compile("(?m)(^\\s*[<]MODE.*?NAME=\"" + name + "\".*?[>])");
                Matcher m = p.matcher(contents);
                String newContents = m.replaceFirst("<!--$1-->");
                p = Pattern.compile("(?m)(</MODES>)");
                m = p.matcher(contents);
                String modeLine = "\t<MODE NAME=\"" + name + "\" FILE=\"" + target.toFile().getName() + "\"" + (String)(filenameGlob == null || filenameGlob.isEmpty() ? "" : " FILE_NAME_GLOB=\"" + filenameGlob + "\"") + (String)(firstLineGlob == null || firstLineGlob.isEmpty() ? "" : " FIRST_LINE_GLOB=\"" + firstLineGlob + "\"") + "/>";
                newContents = m.replaceFirst(modeLine + "\n$1");
                BufferedWriter bw = new BufferedWriter(new FileWriter(catalogFile));
                bw.write(newContents, 0, newContents.length());
                bw.flush();
                bw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addMode(mode);
        this.loadMode(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMode(Mode mode, XModeHandler xmh) {
        BufferedInputStream grammar;
        XMLReader parser;
        String fileName = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + fileName);
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException saxe) {
            Log.log(9, this, saxe);
            return;
        }
        mode.setTokenMarker(xmh.getTokenMarker());
        try {
            grammar = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e1) {
            InputStream resource = ModeProvider.class.getResourceAsStream(fileName);
            if (resource == null) {
                this.error(fileName, e1);
            }
            grammar = new BufferedInputStream(resource);
        }
        try {
            InputSource isrc = new InputSource(grammar);
            isrc.setSystemId("jedit.jar");
            parser.setContentHandler(xmh);
            parser.setDTDHandler(xmh);
            parser.setEntityResolver(xmh);
            parser.setErrorHandler(xmh);
            parser.parse(isrc);
            mode.setProperties(xmh.getModeProperties());
        }
        catch (Throwable e) {
            this.error(fileName, e);
        }
        finally {
            IOUtilities.closeQuietly(grammar);
        }
    }

    public void loadMode(Mode mode) {
        XModeHandler xmh = new XModeHandler(mode.getName()){

            @Override
            public void error(String what, Object subst) {
                Log.log(9, this, subst);
            }

            @Override
            public TokenMarker getTokenMarker(String modeName) {
                Mode mode = ModeProvider.this.getMode(modeName);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xmh);
    }

    protected void error(String file, Throwable e) {
        Log.log(9, this, e);
    }
}

