/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.io.IOException;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryListSet
extends BufferListSet {
    private String directory;
    private String glob;
    private boolean recurse;

    public DirectoryListSet(String directory, String glob, boolean recurse) {
        this.directory = directory;
        this.glob = glob;
        this.recurse = recurse;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
        this.invalidateCachedList();
    }

    public String getFileFilter() {
        return this.glob;
    }

    public void setFileFilter(String glob) {
        this.glob = glob;
        this.invalidateCachedList();
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public void setRecursive(boolean recurse) {
        this.recurse = recurse;
        this.invalidateCachedList();
    }

    @Override
    public String getCode() {
        return "new DirectoryListSet(\"" + StandardUtilities.charsToEscapes(this.directory) + "\",\"" + StandardUtilities.charsToEscapes(this.glob) + "\"," + this.recurse + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _getFiles(Component comp) {
        String[] stringArray;
        boolean skipBinary = jEdit.getBooleanProperty("search.skipBinary.toggle");
        boolean skipHidden = jEdit.getBooleanProperty("search.skipHidden.toggle");
        VFS vfs = VFSManager.getVFSForPath(this.directory);
        Object session = vfs.createVFSSessionSafe(this.directory, comp);
        try {
            stringArray = vfs._listDirectory(session, this.directory, this.glob, this.recurse, comp, skipBinary, skipHidden);
        }
        catch (Throwable throwable) {
            try {
                vfs._endVFSSession(session, comp);
                throw throwable;
            }
            catch (IOException io) {
                VFSManager.error(comp, this.directory, "ioerror", new String[]{io.toString()});
                return null;
            }
        }
        vfs._endVFSSession(session, comp);
        return stringArray;
    }
}

