/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class PluginListHandler
extends DefaultHandler {
    private final PluginList pluginList;
    private PluginList.PluginSet pluginSet;
    private final StringBuilder pluginSetEntry;
    private PluginList.Plugin plugin;
    private String jar;
    private final StringBuilder author;
    private PluginList.Branch branch;
    private boolean obsolete;
    private String version;
    private String date;
    private final StringBuilder download;
    private int downloadSize;
    private final StringBuilder downloadSource;
    private int downloadSourceSize;
    private int size;
    private String depWhat;
    private String depFrom;
    private String depTo;
    private String depPlugin;
    private String name;
    private final StringBuilder description;
    private final Stack<String> stateStack = new Stack();

    PluginListHandler(PluginList pluginList) {
        this.pluginList = pluginList;
        this.author = new StringBuilder();
        this.description = new StringBuilder();
        this.pluginSetEntry = new StringBuilder();
        this.download = new StringBuilder();
        this.downloadSource = new StringBuilder();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "plugins.dtd", this.getClass());
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        switch (aname) {
            case "NAME": {
                this.name = value;
                break;
            }
            case "JAR": {
                this.jar = value;
                break;
            }
            case "VERSION": {
                this.version = value;
                break;
            }
            case "DATE": {
                this.date = value;
                break;
            }
            case "OBSOLETE": {
                this.obsolete = "TRUE".equals(value);
                break;
            }
            case "WHAT": {
                this.depWhat = value;
                break;
            }
            case "FROM": {
                this.depFrom = value;
                break;
            }
            case "TO": {
                this.depTo = value;
                break;
            }
            case "PLUGIN": {
                this.depPlugin = value;
                break;
            }
            case "SIZE": {
                this.size = Integer.parseInt(value);
                if (this.size != 0) break;
                Log.log(7, this, "SIZE = 0");
            }
        }
    }

    @Override
    public void characters(char[] c, int off, int len) {
        String tag;
        switch (tag = this.peekElement()) {
            case "DESCRIPTION": {
                this.description.append(c, off, len);
                break;
            }
            case "PLUGIN_SET_ENTRY": {
                this.pluginSetEntry.append(c, off, len);
                break;
            }
            case "AUTHOR": {
                if (this.author.length() != 0) {
                    this.author.append(", ");
                }
                this.author.append(c, off, len);
                break;
            }
            case "DOWNLOAD": {
                this.download.append(c, off, len);
                break;
            }
            case "DOWNLOAD_SOURCE": {
                this.downloadSource.append(c, off, len);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String tag, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String aName = attrs.getQName(i);
            String aValue = attrs.getValue(i);
            this.attribute(aName, aValue, true);
        }
        switch (tag = this.pushElement(tag)) {
            case "PLUGIN_SET": {
                this.description.setLength(0);
                this.pluginSet = new PluginList.PluginSet();
                this.pluginSet.name = this.name;
                break;
            }
            case "PLUGIN": {
                this.description.setLength(0);
                this.author.setLength(0);
                this.branch = null;
                this.plugin = new PluginList.Plugin();
                break;
            }
            case "BRANCH": {
                this.download.setLength(0);
                this.branch = new PluginList.Branch();
                break;
            }
            case "DOWNLOAD": {
                this.downloadSize = this.size;
                break;
            }
            case "DOWNLOAD_SOURCE": {
                this.downloadSourceSize = this.size;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String tag) {
        this.popElement();
        switch (tag) {
            case "PLUGIN_SET": {
                this.pluginList.addPluginSet(this.pluginSet);
                this.pluginSet = null;
                this.pluginSetEntry.setLength(0);
                break;
            }
            case "PLUGIN_SET_ENTRY": {
                this.pluginSet.plugins.add(this.pluginSetEntry.toString());
                this.pluginSetEntry.setLength(0);
                break;
            }
            case "PLUGIN": {
                this.plugin.jar = this.jar;
                this.plugin.name = this.name;
                this.plugin.author = this.author.toString();
                this.plugin.description = this.description.toString();
                this.pluginList.addPlugin(this.plugin);
                this.jar = null;
                this.name = null;
                this.author.setLength(0);
                this.description.setLength(0);
                break;
            }
            case "BRANCH": {
                this.branch.version = this.version;
                this.branch.date = this.date;
                this.branch.download = this.download.toString();
                this.branch.downloadSize = this.downloadSize;
                this.branch.downloadSource = this.downloadSource.toString();
                this.branch.downloadSourceSize = this.downloadSourceSize;
                this.branch.obsolete = this.obsolete;
                this.plugin.branches.add(this.branch);
                this.version = null;
                this.download.setLength(0);
                this.downloadSource.setLength(0);
                this.obsolete = false;
                break;
            }
            case "DEPEND": {
                PluginList.Dependency dep = new PluginList.Dependency(this.depWhat, this.depFrom, this.depTo, this.depPlugin);
                this.branch.deps.add(dep);
                this.depWhat = null;
                this.depFrom = null;
                this.depTo = null;
                this.depPlugin = null;
            }
        }
    }

    @Override
    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    @Override
    public void endDocument() {
        this.pluginList.finished();
    }

    private String pushElement(String name) {
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

