/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorListHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MirrorList {
    private final String xml;
    private final List<Mirror> mirrors;

    public static MirrorList mirrorListFromDisk(ProgressObserver progressObserver) throws IOException, SAXException, ParserConfigurationException {
        Log.log(5, MirrorList.class, "Loading mirror list from cache");
        String xml = MirrorList.readXml().orElseThrow(() -> new IOException("Unable to read local mirror cache"));
        return new MirrorList(xml, progressObserver);
    }

    public static MirrorList mirrorListFromInternet(ProgressObserver progressObserver) throws IOException, ParserConfigurationException, SAXException {
        Log.log(5, MirrorList.class, "Loading mirror list from internet");
        String path = jEdit.getProperty("plugin-manager.mirror-url");
        String xml = MirrorList.downloadXml(path).orElseThrow(() -> new IOException("Unable to load remote mirror cache"));
        return new MirrorList(xml, progressObserver);
    }

    public MirrorList(String xml, ProgressObserver observer) throws ParserConfigurationException, SAXException, IOException {
        this.xml = xml;
        this.mirrors = new ArrayList<Mirror>();
        Mirror none = new Mirror();
        none.id = "NONE";
        none.continent = "";
        none.country = "";
        none.location = "";
        none.description = "";
        this.mirrors.add(none);
        MirrorListHandler handler = new MirrorListHandler(this);
        observer.setValue(1L);
        BufferedReader in = new BufferedReader(new StringReader(xml));
        InputSource isrc = new InputSource(in);
        isrc.setSystemId("jedit.jar");
        XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        parser.setContentHandler(handler);
        parser.setDTDHandler(handler);
        parser.setEntityResolver(handler);
        parser.setErrorHandler(handler);
        parser.parse(isrc);
        observer.setValue(2L);
    }

    public String getXml() {
        return this.xml;
    }

    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    private static Optional<String> readXml() {
        return MirrorList.getMirrorListFile().filter(file -> Files.exists(file, new LinkOption[0])).flatMap(MirrorList::readFile);
    }

    public void saveXml() {
        MirrorList.getMirrorListFile().ifPresent(this::saveFile);
    }

    private static Optional<String> readFile(Path path) {
        try {
            return Optional.of(Files.readString(path));
        }
        catch (IOException e) {
            Log.log(9, MirrorList.class, "Unable to read path " + String.valueOf(path), e);
            return Optional.empty();
        }
    }

    private void saveFile(Path path) {
        try {
            Files.writeString(path, (CharSequence)this.xml, new OpenOption[0]);
        }
        catch (IOException e) {
            Log.log(9, this, "Unable to write cached mirror list : " + this.xml, e);
        }
    }

    private static Optional<Path> getMirrorListFile() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return Optional.empty();
        }
        Path mirrorList = Path.of(MiscUtilities.constructPath(settingsDirectory, "mirrorList.xml"), new String[0]);
        return Optional.of(mirrorList);
    }

    private static Optional<String> downloadXml(String path) throws IOException {
        try (InputStream inputStream = new URL(path).openStream();){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, inputStream, out, false);
            Optional<String> optional = Optional.of(out.toString());
            return optional;
        }
    }

    void add(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    void finished() {
        this.mirrors.sort(new MirrorCompare());
    }

    public static class Mirror {
        public static final String NONE = "NONE";
        public String id;
        public String description;
        public String location;
        public String country;
        public String continent;
    }

    private static class MirrorCompare
    implements Comparator<Mirror> {
        private MirrorCompare() {
        }

        @Override
        public int compare(Mirror m1, Mirror m2) {
            int result = m1.continent.compareToIgnoreCase(m2.continent);
            if (result == 0 && (result = m1.country.compareToIgnoreCase(m2.country)) == 0 && (result = m1.location.compareToIgnoreCase(m2.location)) == 0) {
                return m1.description.compareToIgnoreCase(m2.description);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MirrorCompare;
        }
    }
}

