/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

class WindowTableModel
extends AbstractTableModel {
    private static final String PLUGIN_SET_PREFIX = "Plugin: ";
    private static final String CORE_DOCKABLE_SET = "Core";
    private static final String ALL_DOCKABLE_SET = "All";
    private final Map<String, List<Entry>> dockableSets = new HashMap<String, List<Entry>>();
    private List<Entry> windows;

    WindowTableModel() {
        String[] dockables;
        ArrayList<Entry> all = new ArrayList<Entry>();
        this.dockableSets.put(ALL_DOCKABLE_SET, all);
        this.windows = new ArrayList<Entry>();
        for (String dockable : dockables = DockableWindowManager.getRegisteredDockableWindows()) {
            String plugin = DockableWindowManager.getDockableWindowPluginName(dockable);
            Object set = plugin != null ? PLUGIN_SET_PREFIX + plugin : CORE_DOCKABLE_SET;
            List currentSetDockables = this.dockableSets.computeIfAbsent((String)set, k -> new ArrayList());
            Entry entry = new Entry(dockable);
            currentSetDockables.add(entry);
            all.add(entry);
        }
        this.showSet(ALL_DOCKABLE_SET);
    }

    public List<String> getDockableSets() {
        ArrayList<String> sets = new ArrayList<String>(this.dockableSets.keySet());
        sets.remove(ALL_DOCKABLE_SET);
        sets.remove(CORE_DOCKABLE_SET);
        Collections.sort(sets);
        sets.add(0, CORE_DOCKABLE_SET);
        sets.add(0, ALL_DOCKABLE_SET);
        return sets;
    }

    public void showSet(String set) {
        this.windows = this.dockableSets.get(set);
        this.windows.sort(new WindowCompare());
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.windows.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Entry window = this.windows.get(row);
        switch (col) {
            case 0: {
                return window.title;
            }
            case 1: {
                return window.dockPosition;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry window = this.windows.get(row);
        switch (col) {
            case 1: {
                window.dockPosition = (String)value;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.docking.title");
            }
            case 1: {
                return jEdit.getProperty("options.docking.dockPosition");
            }
        }
        throw new InternalError();
    }

    public void save() {
        this.windows.forEach(Entry::save);
    }

    private static class Entry {
        final String name;
        private String title;
        private String dockPosition;

        Entry(String name) {
            this.name = name;
            this.title = jEdit.getProperty(name + ".title");
            if (this.title == null) {
                this.title = name;
            }
            this.dockPosition = jEdit.getProperty(name + ".dock-position");
            if (this.dockPosition == null) {
                this.dockPosition = "floating";
            }
        }

        void save() {
            jEdit.setProperty(this.name + ".dock-position", this.dockPosition);
        }
    }

    static class WindowCompare
    implements Comparator<Object> {
        WindowCompare() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Entry e1 = (Entry)obj1;
            Entry e2 = (Entry)obj2;
            return StandardUtilities.compareStrings(e1.title, e2.title, true);
        }
    }
}

