/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel mirrorLabel;
    private JCheckBox disableObsolete;
    private JRadioButton settingsDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private SpinnerNumberModel spinnerModel;
    private MirrorModel miraModel;
    private JList<String> miraList;
    private JButton updateMirrors;
    private final JLabel updateStatus = new JLabel();

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.mirrorLabel = new JLabel();
        this.updateMirrorLabel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JPanel spinnerPanel = null;
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
            int delay = jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 10);
            this.spinnerModel = new SpinnerNumberModel(delay, 0, 240, 5);
            JSpinner cacheForSpinner = new JSpinner(this.spinnerModel);
            spinnerPanel = new JPanel();
            spinnerPanel.setLayout(new BoxLayout(spinnerPanel, 0));
            spinnerPanel.add(new JLabel(jEdit.getProperty("options.plugin-manager.list-cache.minutes")));
            spinnerPanel.add(cacheForSpinner);
            spinnerPanel.add(Box.createGlue());
        }
        JRadioButton appDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        appDir.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList<String>(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        buttonPanel.add(Box.createVerticalStrut(6));
        this.updateMirrors = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        this.updateMirrors.addActionListener(e -> {
            this.updateMirrors.setEnabled(false);
            this.updateStatus.setText(jEdit.getProperty("options.plugin-manager.workthread"));
            ThreadUtilities.runInBackground(new UpdateMirrorsThread(true));
        });
        this.updateMirrors.setEnabled(false);
        ThreadUtilities.runInBackground(new UpdateMirrorsThread(false));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.updateMirrors);
        if (spinnerPanel != null) {
            panel.add(spinnerPanel);
        }
        panel.add(this.updateStatus);
        panel.setAlignmentX(0.0f);
        buttonPanel.add(panel);
        buttonPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        this.downloadSource.setAlignmentX(0.0f);
        buttonPanel.add(this.downloadSource);
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        this.deleteDownloads.setAlignmentX(0.0f);
        buttonPanel.add(this.deleteDownloads);
        this.disableObsolete = new JCheckBox(jEdit.getProperty("options.plugin-manager.disable-obsolete"));
        this.disableObsolete.setSelected(jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true));
        this.disableObsolete.setAlignmentX(0.0f);
        buttonPanel.add(this.disableObsolete);
        buttonPanel.add(Box.createVerticalStrut(6));
        ButtonGroup locGrp = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            locGrp.add(this.settingsDir);
        }
        locGrp.add(appDir);
        JPanel locPanel = new JPanel();
        locPanel.setLayout(new BoxLayout(locPanel, 1));
        if (jEdit.getSettingsDirectory() != null) {
            locPanel.add(this.settingsDir);
            locPanel.add(Box.createVerticalStrut(3));
        }
        locPanel.setBorder(new TitledBorder(jEdit.getProperty("options.plugin-manager.location")));
        locPanel.add(appDir);
        locPanel.setAlignmentX(0.0f);
        buttonPanel.add(locPanel);
        buttonPanel.add(Box.createGlue());
        this.add("South", buttonPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            appDir.setSelected(true);
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        jEdit.setIntegerProperty("plugin-manager.list-cache.minutes", this.spinnerModel.getNumber().intValue());
        jEdit.setBooleanProperty("plugin-manager.disable-obsolete", this.disableObsolete.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String currentMirror = this.miraModel.getID(this.miraList.getSelectedIndex());
            String previousMirror = jEdit.getProperty("plugin-manager.mirror.id");
            if (!previousMirror.equals(currentMirror)) {
                jEdit.setProperty("plugin-manager.mirror.id", currentMirror);
                jEdit.setProperty("plugin-manager.mirror.name", this.miraModel.getElementAt(this.miraList.getSelectedIndex()));
                this.updateMirrorLabel();
            }
        }
    }

    private void updateMirrorLabel() {
        String mirrorName;
        String currentMirror = jEdit.getProperty("plugin-manager.mirror.id");
        if (currentMirror.equals("NONE")) {
            mirrorName = "Plugin Central default";
        } else {
            mirrorName = jEdit.getProperty("plugin-manager.mirror.name");
            if (mirrorName == null) {
                mirrorName = currentMirror;
            }
        }
        this.mirrorLabel.setText(jEdit.getProperty("options.plugin-manager.mirror") + " " + mirrorName);
    }

    static class MirrorModel
    extends AbstractListModel<String> {
        private List<MirrorList.Mirror> mirrors = new ArrayList<MirrorList.Mirror>();

        MirrorModel() {
        }

        public String getID(int index) {
            return this.mirrors.get((int)index).id;
        }

        @Override
        public int getSize() {
            return this.mirrors.size();
        }

        @Override
        public String getElementAt(int index) {
            MirrorList.Mirror mirror = this.mirrors.get(index);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ")";
        }

        public void setList(List<MirrorList.Mirror> mirrors) {
            this.mirrors = mirrors;
            this.fireContentsChanged(this, 0, mirrors.size() - 1);
        }
    }

    static class SingleSelectionModel
    extends DefaultListSelectionModel {
        SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }
    }

    class UpdateMirrorsThread
    extends Task {
        private final boolean download;

        UpdateMirrorsThread(boolean download) {
            this.download = download;
        }

        @Override
        public void _run() {
            try {
                ArrayList<MirrorList.Mirror> mirrors;
                block7: {
                    this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
                    this.setMaximum(3L);
                    this.setValue(0L);
                    mirrors = new ArrayList<MirrorList.Mirror>();
                    try {
                        MirrorList mirrorList;
                        if (this.download) {
                            mirrorList = MirrorList.mirrorListFromInternet(this);
                            mirrorList.saveXml();
                        } else {
                            mirrorList = MirrorList.mirrorListFromDisk(this);
                        }
                        mirrors.addAll(mirrorList.getMirrors());
                    }
                    catch (Exception ex) {
                        if (!this.download) break block7;
                        Log.log(9, this, ex);
                        ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{ex.toString()}));
                    }
                }
                ThreadUtilities.runInDispatchThread(() -> {
                    PluginManagerOptionPane.this.miraModel.setList(mirrors);
                    String id = jEdit.getProperty("plugin-manager.mirror.id");
                    int size = PluginManagerOptionPane.this.miraModel.getSize();
                    for (int i = 0; i < size; ++i) {
                        if (size != 1 && !PluginManagerOptionPane.this.miraModel.getID(i).equals(id)) continue;
                        PluginManagerOptionPane.this.miraList.setSelectedIndex(i);
                        break;
                    }
                    if (size == 0) {
                        PluginManagerOptionPane.this.miraList.clearSelection();
                    }
                });
                this.setValue(3L);
            }
            finally {
                ThreadUtilities.runInDispatchThread(() -> {
                    PluginManagerOptionPane.this.updateMirrors.setEnabled(true);
                    PluginManagerOptionPane.this.updateStatus.setText(null);
                });
            }
        }
    }
}

