/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.RegisterChanged;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.swing.event.UniqueActionDocumentListener;

public class RegisterViewer
extends JPanel
implements DockableWindow,
DefaultFocusComponent {
    private final JList<String> registerList;
    private final JTextArea contentTextArea;
    private final DocumentListener documentHandler;
    private final View view;
    private boolean editing;
    private final JSplitPane splitPane;
    private JPopupMenu popup;

    public RegisterViewer(View view, String position) {
        super(new BorderLayout());
        this.view = view;
        Box toolBar = new Box(0);
        JLabel label = new JLabel(jEdit.getProperty("view-registers.title"));
        label.setBorder(new EmptyBorder(0, 0, 3, 0));
        toolBar.add(label);
        toolBar.add(Box.createGlue());
        RolloverButton pasteRegister = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("paste.icon")));
        pasteRegister.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("paste-string-register.label")));
        pasteRegister.addActionListener(e -> this.insertRegister());
        pasteRegister.setActionCommand("paste-string-register");
        toolBar.add(pasteRegister);
        RolloverButton clearRegister = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.clearAll.icon")));
        clearRegister.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("clear-string-register.label")));
        clearRegister.addActionListener(e -> this.clearSelectedIndex());
        clearRegister.setActionCommand("clear-string-register");
        toolBar.add(clearRegister);
        this.add("North", toolBar);
        DefaultListModel registerModel = new DefaultListModel();
        this.registerList = new JList(registerModel);
        this.registerList.setSelectionMode(0);
        this.registerList.setCellRenderer(new Renderer());
        this.registerList.addListSelectionListener(new ListHandler());
        this.registerList.addMouseListener(new MouseHandler());
        this.contentTextArea = new JTextArea(10, 20);
        this.contentTextArea.setEditable(true);
        this.documentHandler = new UniqueActionDocumentListener(e -> this.updateRegisterSafely());
        this.contentTextArea.addFocusListener(new FocusHandler());
        this.registerKeyboardAction(e -> {
            view.getTextArea().requestFocus();
            view.toFront();
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.registerList.registerKeyboardAction(e -> this.insertRegister(), KeyStroke.getKeyStroke(10, 0), 0);
        this.registerList.registerKeyboardAction(e -> this.insertRegister(), KeyStroke.getKeyStroke(155, 0), 0);
        this.registerList.registerKeyboardAction(e -> this.clearSelectedIndex(), KeyStroke.getKeyStroke(127, 0), 0);
        this.contentTextArea.registerKeyboardAction(e -> this.registerList.requestFocusInWindow(), KeyStroke.getKeyStroke(9, 64), 0);
        int orientation = 1;
        if (position.equals("left") || position.equals("right")) {
            orientation = 0;
        }
        this.splitPane = new JSplitPane(orientation, new JScrollPane(this.registerList), new JScrollPane(this.contentTextArea));
        this.add("Center", this.splitPane);
        this.refreshList();
    }

    @Override
    public void focusOnDefaultComponent() {
        this.registerList.requestFocusInWindow();
    }

    @EditBus.EBHandler
    public void handleRegisterChanged(RegisterChanged msg) {
        if (msg.getRegisterName() != '%') {
            this.refreshList();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    @Override
    public void move(String newPosition) {
        int orientation = 1;
        if (newPosition.equals("left") || newPosition.equals("right")) {
            orientation = 0;
        }
        this.splitPane.setOrientation(orientation);
        this.revalidate();
    }

    private void refreshList() {
        DefaultListModel registerModel = (DefaultListModel)this.registerList.getModel();
        String o = this.registerList.getSelectedValue();
        int selected = -1;
        if (o != null && o.length() == 1) {
            selected = o.charAt(0);
        }
        registerModel.removeAllElements();
        Registers.Register[] registers = Registers.getRegisters();
        int index = 0;
        for (int i = 0; i < registers.length; ++i) {
            String value;
            Registers.Register reg = registers[i];
            if (reg == null || i == 37 || (value = reg.toString()) == null) continue;
            if (i == selected) {
                index = registerModel.size();
            }
            registerModel.addElement(String.valueOf((char)i));
        }
        if (registerModel.getSize() == 0) {
            registerModel.addElement(jEdit.getProperty("view-registers.none"));
            this.registerList.setEnabled(false);
        } else {
            this.registerList.setEnabled(true);
        }
        this.registerList.setSelectedIndex(index);
    }

    private void insertRegister() {
        String o = this.registerList.getSelectedValue();
        if (o == null || o.length() > 1) {
            return;
        }
        Registers.Register reg = Registers.getRegister(o.charAt(0));
        this.view.getTextArea().setSelectedText(reg.toString());
        this.view.getTextArea().requestFocus();
        DockableWindowManager dm = this.view.getDockableWindowManager();
        if (!dm.isDockableWindowDocked("view-registers")) {
            dm.hideDockableWindow("view-registers");
        }
    }

    private void clearSelectedIndex() {
        String o = this.registerList.getSelectedValue();
        if (o != null && o.length() == 1) {
            Registers.clearRegister(o.charAt(0));
            this.refreshList();
        }
    }

    private void updateRegisterSafely() {
        try {
            this.editing = true;
            this.updateRegister();
        }
        finally {
            this.editing = false;
        }
    }

    private void updateRegister() {
        String value = this.registerList.getSelectedValue();
        if (value == null || value.length() < 1) {
            return;
        }
        char name = value.charAt(0);
        Registers.setRegister(name, this.contentTextArea.getText());
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!jEdit.getProperty("view-registers.none").equals(value)) {
                Object registerValue;
                char name = value.toString().charAt(0);
                String label = name == '\n' ? "\n" : (name == '\t' ? "\t" : (name == '$' ? jEdit.getProperty("view-registers.clipboard") : (name == '%' ? jEdit.getProperty("view-registers.selection") : String.valueOf(name))));
                Registers.Register register = Registers.getRegister(name);
                if (register == null) {
                    registerValue = jEdit.getProperty("view-registers.undefined");
                } else {
                    registerValue = register.toString();
                    if (((String)registerValue).length() > 100) {
                        registerValue = ((String)registerValue).substring(0, 100) + "...";
                    }
                    registerValue = ((String)registerValue).replaceAll("\n", " ");
                    registerValue = ((String)registerValue).replaceAll("\t", " ");
                }
                this.setText(label + " : " + (String)registerValue);
            }
            return this;
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            String value = RegisterViewer.this.registerList.getSelectedValue();
            if (value == null || value.length() < 1) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            char name = value.charAt(0);
            Registers.Register reg = Registers.getRegister(name);
            if (reg == null) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            if (!RegisterViewer.this.editing) {
                RegisterViewer.this.contentTextArea.setText(reg.toString());
                RegisterViewer.this.contentTextArea.setEditable(true);
                RegisterViewer.this.contentTextArea.setCaretPosition(0);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int i = RegisterViewer.this.registerList.locationToIndex(evt.getPoint());
            if (i != -1) {
                RegisterViewer.this.registerList.setSelectedIndex(i);
            }
            if (GenericGUIUtilities.isPopupTrigger(evt)) {
                if (RegisterViewer.this.popup == null) {
                    RegisterViewer.this.popup = new JPopupMenu();
                    JMenuItem item = GUIUtilities.loadMenuItem("paste");
                    RegisterViewer.this.popup.add(item);
                    item = new JMenuItem(jEdit.getProperty("clear-string-register.label"));
                    item.addActionListener(e -> RegisterViewer.this.clearSelectedIndex());
                    RegisterViewer.this.popup.add(item);
                }
                GenericGUIUtilities.showPopupMenu(RegisterViewer.this.popup, RegisterViewer.this.registerList, evt.getX(), evt.getY(), false);
            } else if (evt.getClickCount() % 2 == 0) {
                RegisterViewer.this.insertRegister();
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            RegisterViewer.this.contentTextArea.getDocument().addDocumentListener(RegisterViewer.this.documentHandler);
        }

        @Override
        public void focusLost(FocusEvent e) {
            RegisterViewer.this.contentTextArea.getDocument().removeDocumentListener(RegisterViewer.this.documentHandler);
        }
    }
}

