/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockablePanel;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.gui.RolloverToggleButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.StandardUtilities;

public class PanelWindowContainer
implements DockableWindowContainer,
DockableWindowManager.DockingArea {
    static final int SPLITTER_WIDTH = 10;
    DockablePanel dockablePanel;
    JPanel buttonPanel;
    private final DockableWindowManagerImpl wm;
    private final String position;
    private final JButton closeBox;
    private final JButton menuBtn;
    private final ButtonGroup buttonGroup;
    private final JToggleButton nullButton;
    private int dimension;
    private final List<DockableWindowManagerImpl.Entry> dockables;
    private final List<AbstractButton> buttons;
    private DockableWindowManagerImpl.Entry current;
    private JPopupMenu popup;
    @Nullable
    private String mostRecent;

    public PanelWindowContainer(DockableWindowManagerImpl wm, String position, int dimension) {
        this.wm = wm;
        this.position = position;
        this.buttonPanel = new JPanel(new ButtonLayout());
        this.buttonPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.closeBox = new JButton(GUIUtilities.loadIcon("closebox.gif"));
        this.closeBox.setRequestFocusEnabled(false);
        this.closeBox.setToolTipText(jEdit.getProperty("view.docking.close-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.closeBox.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.closeBox.setMargin(new Insets(0, 0, 0, 0));
        GenericGUIUtilities.setButtonContentMargin(this.closeBox, this.closeBox.getMargin());
        this.closeBox.addActionListener(e -> this.show((DockableWindowManagerImpl.Entry)null));
        this.menuBtn = new JButton(GUIUtilities.loadIcon(jEdit.getThemeProperty("dropdown-arrow.icon")));
        this.menuBtn.setRequestFocusEnabled(false);
        this.menuBtn.setToolTipText(jEdit.getProperty("view.docking.menu-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.menuBtn.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.menuBtn.setMargin(new Insets(0, 0, 0, 0));
        GenericGUIUtilities.setButtonContentMargin(this.menuBtn, this.menuBtn.getMargin());
        this.menuBtn.addMouseListener(new MenuMouseHandler());
        this.buttonGroup = new ButtonGroup();
        this.nullButton = new JToggleButton();
        this.buttonGroup.add(this.nullButton);
        this.dockables = new ArrayList<DockableWindowManagerImpl.Entry>();
        this.buttons = new ArrayList<AbstractButton>();
        this.dockablePanel = new DockablePanel(this);
        this.dimension = dimension;
    }

    public DockableWindowManagerImpl getDockableWindowManager() {
        return this.wm;
    }

    @Override
    public void register(DockableWindowManagerImpl.Entry entry) {
        JToggleButton button;
        int rotation;
        this.dockables.add(entry);
        switch (this.position) {
            case "top": 
            case "bottom": {
                rotation = 0;
                break;
            }
            case "left": {
                rotation = 2;
                break;
            }
            case "right": {
                rotation = 1;
                break;
            }
            default: {
                throw new InternalError("Invalid position: " + this.position);
            }
        }
        if (jEdit.getBooleanProperty("use.rolloverToggleButtons")) {
            button = new RolloverToggleButton();
        } else {
            button = new JToggleButton();
            button.setMargin(new Insets(1, 1, 1, 1));
            button.setFont(new JMenuItem().getFont());
        }
        GenericGUIUtilities.setButtonContentMargin(button, new Insets(6, 6, 6, 6));
        button.setRequestFocusEnabled(false);
        String shortTitle = entry.shortTitle();
        button.setIcon(new RotatedTextIcon(rotation, button.getFont(), shortTitle));
        button.putClientProperty("AccessibleName", shortTitle);
        button.setActionCommand(entry.factory.name);
        button.addActionListener(new ActionHandler());
        button.addMouseListener(new MenuMouseHandler());
        if (OperatingSystem.isMacOSLF()) {
            button.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.buttonGroup.add(button);
        this.buttons.add(button);
        entry.btn = button;
        this.wm.revalidate();
    }

    @Override
    public void unregister(DockableWindowManagerImpl.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        if (entry.btn != null) {
            this.buttonPanel.remove(entry.btn);
            this.buttons.remove(entry.btn);
            entry.btn = null;
        }
        this.dockables.remove(entry);
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
        }
        if (this.current == entry) {
            this.current = null;
            this.show(this.current);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
            this.buttonPanel.repaint();
        }
    }

    @Override
    public void remove(DockableWindowManagerImpl.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
            entry.win = null;
        }
        if (this.current == entry) {
            this.current = null;
            this.show(this.current);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
        }
    }

    @Override
    public void showMostRecent() {
        if (this.dockables.isEmpty()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        if (this.mostRecent == null) {
            this.mostRecent = this.dockables.get((int)0).factory.name;
        }
        this.wm.showDockableWindow(this.mostRecent);
    }

    @Override
    public void show(DockableWindowManagerImpl.Entry entry) {
        if (this.current == entry) {
            if (entry != null) {
                if (entry.win instanceof DefaultFocusComponent) {
                    ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                } else {
                    entry.win.requestDefaultFocus();
                }
            }
            return;
        }
        if (entry != null) {
            if (this.current == null) {
                this.dockablePanel.setBorder(new DockBorder(this.position));
            }
            this.mostRecent = entry.factory.name;
            this.current = entry;
            if (entry.win.getParent() != this.dockablePanel) {
                this.dockablePanel.add(entry.factory.name, entry.win);
            }
            this.dockablePanel.showDockable(entry.factory.name);
            entry.btn.setSelected(true);
            if (entry.win instanceof DefaultFocusComponent) {
                ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
            } else {
                entry.win.requestDefaultFocus();
            }
        } else {
            EditBus.send(new DockableWindowUpdate(this.wm, DockableWindowUpdate.DEACTIVATED, this.current.factory.name));
            this.current = null;
            this.nullButton.setSelected(true);
            this.dockablePanel.setBorder(null);
            this.wm.getView().getTextArea().requestFocus();
        }
        this.wm.revalidate();
        this.dockablePanel.repaint();
    }

    @Override
    public boolean isVisible(DockableWindowManagerImpl.Entry entry) {
        return this.current == entry;
    }

    @Override
    public String getCurrent() {
        if (this.current == null) {
            return null;
        }
        return this.current.factory.name;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getPosition() {
        return this.position;
    }

    @Override
    public String[] getDockables() {
        String[] retVal = new String[this.dockables.size()];
        for (int i = 0; i < this.dockables.size(); ++i) {
            DockableWindowManagerImpl.Entry entry = this.dockables.get(i);
            retVal[i] = entry.factory.name;
        }
        return retVal;
    }

    void save() {
        jEdit.setIntegerProperty("view.dock." + this.position + ".dimension", this.dimension);
        if (this.current == null) {
            jEdit.unsetProperty("view.dock." + this.position + ".last");
        } else {
            jEdit.setProperty("view.dock." + this.position + ".last", this.current.factory.name);
        }
    }

    void setDimension(int dimension) {
        if (dimension > 10) {
            this.dimension = dimension - 10;
        }
    }

    void sortDockables() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.closeBox);
        this.buttonPanel.add(this.menuBtn);
        this.buttons.sort(new DockableWindowCompare());
        for (AbstractButton button : this.buttons) {
            this.buttonPanel.add(button);
        }
    }

    int getWrappedDimension(int dimension) {
        return ((ButtonLayout)this.buttonPanel.getLayout()).getWrappedDimension(this.buttonPanel, dimension);
    }

    @Override
    public void show(String name) {
        DockableWindowManagerImpl.Entry entry = null;
        if (name != null) {
            this.wm.showDockableWindow(name);
            this.wm.hideDockableWindow(name);
        }
        this.show(entry);
    }

    private class ButtonLayout
    implements LayoutManager {
        private ButtonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        int getWrappedDimension(JComponent parent, int dimension) {
            Insets insets = parent.getBorder().getBorderInsets(parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                return 0;
            }
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = dimension - insets.right;
                Dimension returnValue = this.preferredLayoutSizeLR(insets, comp, dim, width);
                return returnValue.height;
            }
            Dimension returnValue = this.preferredLayoutSizeTB(dimension, insets, comp, dim);
            return returnValue.width;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = ((JComponent)parent).getBorder().getBorderInsets(parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                return new Dimension(0, 0);
            }
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = parent.getWidth() - insets.right;
                Dimension returnValue = this.preferredLayoutSizeLR(insets, comp, dim, width);
                return returnValue;
            }
            Dimension returnValue = this.preferredLayoutSizeTB(parent.getHeight(), insets, comp, dim);
            return returnValue;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = ((JComponent)parent).getBorder().getBorderInsets(parent);
            Component[] comp = parent.getComponents();
            if (comp.length <= 2) {
                for (Component aComp : comp) {
                    aComp.setVisible(false);
                }
                return;
            }
            comp[0].setVisible(true);
            comp[1].setVisible(true);
            Dimension dim = comp[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int width = parent.getWidth() - insets.right;
                int rowHeight = Math.max(dim.height, PanelWindowContainer.this.closeBox.getPreferredSize().width);
                int x = (rowHeight << 1) + insets.left;
                int y = insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, rowHeight, rowHeight);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left + rowHeight, insets.top, rowHeight, rowHeight);
                for (int i = 2; i < comp.length; ++i) {
                    int btnWidth = comp[i].getPreferredSize().width;
                    if (btnWidth + x > width) {
                        x = insets.left;
                        y += rowHeight;
                    }
                    comp[i].setBounds(x, y, btnWidth, rowHeight);
                    x += btnWidth;
                }
            } else {
                int height = parent.getHeight() - insets.bottom;
                int colWidth = Math.max(dim.width, PanelWindowContainer.this.closeBox.getPreferredSize().height);
                int x = insets.left;
                int y = (colWidth << 1) + insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, colWidth, colWidth);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left, insets.top + colWidth, colWidth, colWidth);
                for (int i = 2; i < comp.length; ++i) {
                    int btnHeight = comp[i].getPreferredSize().height;
                    if (btnHeight + y > height) {
                        x += colWidth;
                        y = insets.top;
                    }
                    comp[i].setBounds(x, y, colWidth, btnHeight);
                    y += btnHeight;
                }
            }
        }

        private Dimension preferredLayoutSizeLR(Insets insets, Component[] comp, Dimension dim, int width) {
            int rowHeight = Math.max(dim.height, PanelWindowContainer.this.closeBox.getPreferredSize().width);
            int x = (rowHeight << 1) + insets.left;
            Dimension returnValue = new Dimension(0, rowHeight + insets.top + insets.bottom);
            for (int i = 2; i < comp.length; ++i) {
                int btnWidth = comp[i].getPreferredSize().width;
                if (btnWidth + x > width) {
                    returnValue.height += rowHeight;
                    x = insets.left;
                }
                x += btnWidth;
            }
            return returnValue;
        }

        private Dimension preferredLayoutSizeTB(int dimension, Insets insets, Component[] comp, Dimension dim) {
            int height = dimension - insets.bottom;
            int colWidth = Math.max(dim.width, PanelWindowContainer.this.closeBox.getPreferredSize().height);
            int y = (colWidth << 1) + insets.top;
            Dimension returnValue = new Dimension(colWidth + insets.left + insets.right, 0);
            for (int i = 2; i < comp.length; ++i) {
                int btnHeight = comp[i].getPreferredSize().height;
                if (btnHeight + y > height) {
                    returnValue.width += colWidth;
                    y = insets.top;
                }
                y += btnHeight;
            }
            return returnValue;
        }
    }

    class MenuMouseHandler
    extends MouseAdapter {
        MenuMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
                return;
            }
            Component comp = (Component)evt.getSource();
            String dockable = comp instanceof JToggleButton ? ((JToggleButton)comp).getActionCommand() : PanelWindowContainer.this.getCurrent();
            if (comp == PanelWindowContainer.this.menuBtn || GenericGUIUtilities.isPopupTrigger(evt)) {
                boolean point;
                int y;
                int x;
                PanelWindowContainer.this.popup = dockable == null ? PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, null, false) : PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, dockable, false);
                if (comp == PanelWindowContainer.this.menuBtn) {
                    x = 0;
                    y = PanelWindowContainer.this.menuBtn.getHeight();
                    point = false;
                } else {
                    x = evt.getX();
                    y = evt.getY();
                    point = true;
                }
                GenericGUIUtilities.showPopupMenu(PanelWindowContainer.this.popup, comp, x, y, point);
            }
        }
    }

    public static class RotatedTextIcon
    implements Icon {
        public static final int NONE = 0;
        public static final int CW = 1;
        public static final int CCW = 2;
        private final int rotate;
        private final Font font;
        private final GlyphVector glyphs;
        private final float width;
        private final float height;
        private final float ascent;
        private final RenderingHints renderHints;

        public RotatedTextIcon(int rotate, Font font, String text) {
            this.rotate = rotate;
            this.font = font;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            this.glyphs = font.createGlyphVector(fontRenderContext, text);
            this.width = (int)this.glyphs.getLogicalBounds().getWidth() + 4;
            LineMetrics lineMetrics = font.getLineMetrics(text, fontRenderContext);
            this.ascent = lineMetrics.getAscent();
            this.height = (int)lineMetrics.getHeight();
            this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        @Override
        public int getIconWidth() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.height : this.width);
        }

        @Override
        public int getIconHeight() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.width : this.height);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(this.font);
            AffineTransform oldTransform = g2d.getTransform();
            RenderingHints oldHints = g2d.getRenderingHints();
            g2d.setRenderingHints(this.renderHints);
            g2d.setColor(c.getForeground());
            if (this.rotate == 0) {
                g2d.drawGlyphVector(this.glyphs, x + 2, (float)y + this.ascent);
            } else if (this.rotate == 1) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(oldTransform);
                trans.translate(x, y + 2);
                trans.rotate(1.5707963267948966, this.height / 2.0f, this.width / 2.0f);
                g2d.setTransform(trans);
                g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            } else if (this.rotate == 2) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(oldTransform);
                trans.translate(x, y - 2);
                trans.rotate(4.71238898038469, this.height / 2.0f, this.width / 2.0f);
                g2d.setTransform(trans);
                g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            }
            g2d.setTransform(oldTransform);
            g2d.setRenderingHints(oldHints);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
            }
            if (PanelWindowContainer.this.wm.isDockableWindowVisible(evt.getActionCommand())) {
                PanelWindowContainer.this.show((DockableWindowManagerImpl.Entry)null);
            } else {
                PanelWindowContainer.this.wm.showDockableWindow(evt.getActionCommand());
            }
        }
    }

    private static class DockBorder
    implements Border {
        private final String position;
        private final Insets insets;
        private Color color1;
        private Color color2;
        private Color color3;

        DockBorder(String position) {
            this.position = position;
            this.insets = new Insets(position.equals("bottom") ? 10 : 0, position.equals("right") ? 10 : 0, position.equals("top") ? 10 : 0, position.equals("left") ? 10 : 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColors();
            if (this.color1 == null || this.color2 == null || this.color3 == null) {
                return;
            }
            switch (this.position) {
                case "bottom": {
                    this.paintHorizBorder(g, x, y, width);
                    break;
                }
                case "right": {
                    this.paintVertBorder(g, x, y, height);
                    break;
                }
                case "top": {
                    this.paintHorizBorder(g, x, y + height - 10, width);
                    break;
                }
                case "left": {
                    this.paintVertBorder(g, x + width - 10, y, height);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private void paintHorizBorder(Graphics g, int x, int y, int width) {
            g.setColor(this.color3);
            g.fillRect(x, y, width, 10);
            for (int i = 0; i < width / 4 - 1; ++i) {
                g.setColor(this.color1);
                g.drawLine(x + (i << 2) + 2, y + 3, x + (i << 2) + 2, y + 3);
                g.setColor(this.color2);
                g.drawLine(x + (i << 2) + 3, y + 4, x + (i << 2) + 3, y + 4);
                g.setColor(this.color1);
                g.drawLine(x + (i << 2) + 4, y + 5, x + (i << 2) + 4, y + 5);
                g.setColor(this.color2);
                g.drawLine(x + (i << 2) + 5, y + 6, x + (i << 2) + 5, y + 6);
            }
        }

        private void paintVertBorder(Graphics g, int x, int y, int height) {
            g.setColor(this.color3);
            g.fillRect(x, y, 10, height);
            for (int i = 0; i < height / 4 - 1; ++i) {
                g.setColor(this.color1);
                g.drawLine(x + 3, y + (i << 2) + 2, x + 3, y + (i << 2) + 2);
                g.setColor(this.color2);
                g.drawLine(x + 4, y + (i << 2) + 3, x + 4, y + (i << 2) + 3);
                g.setColor(this.color1);
                g.drawLine(x + 5, y + (i << 2) + 4, x + 5, y + (i << 2) + 4);
                g.setColor(this.color2);
                g.drawLine(x + 6, y + (i << 2) + 5, x + 6, y + (i << 2) + 5);
            }
        }

        private void updateColors() {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                this.color1 = MetalLookAndFeel.getControlHighlight();
                this.color2 = MetalLookAndFeel.getControlDarkShadow();
                this.color3 = MetalLookAndFeel.getControl();
            } else {
                this.color3 = null;
                this.color2 = null;
                this.color1 = null;
            }
        }
    }

    static class DockableWindowCompare
    implements Comparator<AbstractButton> {
        DockableWindowCompare() {
        }

        @Override
        public int compare(AbstractButton o1, AbstractButton o2) {
            String name1 = o1.getActionCommand();
            String name2 = o2.getActionCommand();
            return StandardUtilities.compareStrings(jEdit.getProperty(name1 + ".title", ""), jEdit.getProperty(name2 + ".title", ""), true);
        }
    }
}

