/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.font.FontRenderContext;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.DynamicContextMenuService;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.SplashScreen;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedCheckBoxMenuItem;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;
import org.jedit.keymap.Keymap;

public class GUIUtilities {
    private static SplashScreen splash;
    private static SoftReference<Map<String, Icon>> iconCache;
    private static String iconPath;
    private static final String defaultIconPath = "jeditresource:/org/gjt/sp/jedit/icons/themes/";
    private static final Map<String, String> deprecatedIcons;
    private static HashMap<String, String> macKeySymbols;
    private static final AtomicLong executorThreadsCounter;
    private static final ScheduledExecutorService schedExecutor;

    public static void setIconPath(String iconPath) {
        GUIUtilities.iconPath = iconPath;
        iconCache = null;
    }

    public static Icon loadIcon(String iconSpec) {
        URL url;
        Icon icon;
        if (iconSpec == null) {
            return null;
        }
        if (deprecatedIcons.containsKey(iconSpec)) {
            iconSpec = deprecatedIcons.get(iconSpec);
        }
        Map<String, Icon> cache = null;
        if (iconCache != null) {
            cache = iconCache.get();
        }
        if (cache == null) {
            cache = new HashMap<String, Icon>();
            iconCache = new SoftReference<Map<String, Icon>>(cache);
        }
        if ((icon = cache.get(iconSpec)) != null) {
            return icon;
        }
        float iconScale = 1.0f;
        String iconName = iconSpec;
        Matcher matcher = Pattern.compile("^([^?]+)\\?scale=(.+)$").matcher(iconSpec);
        if (matcher.matches()) {
            try {
                iconScale = Float.valueOf(matcher.group(2)).floatValue();
                iconName = matcher.group(1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            url = MiscUtilities.isURL(iconName) ? new URL(iconName) : new URL(iconPath + iconName);
        }
        catch (Exception e) {
            try {
                url = new URL(defaultIconPath + iconName);
            }
            catch (Exception ex) {
                Log.log(9, GUIUtilities.class, "Icon not found: " + iconName);
                Log.log(9, GUIUtilities.class, ex);
                return null;
            }
        }
        icon = url.toString().endsWith(".svg") ? new FlatSVGIcon(url).derive(iconScale) : new ImageIcon(url);
        cache.put(iconSpec, icon);
        return icon;
    }

    public static Image getEditorIcon() {
        return ((ImageIcon)GUIUtilities.loadIcon(jEdit.getProperty("logo.icon.medium"))).getImage();
    }

    public static Image getPluginIcon() {
        return GUIUtilities.getEditorIcon();
    }

    public static JMenuBar loadMenuBar(String name) {
        return GUIUtilities.loadMenuBar(jEdit.getActionContext(), name);
    }

    public static JMenuBar loadMenuBar(ActionContext context, String name) {
        String menus = jEdit.getProperty(name);
        StringTokenizer st = new StringTokenizer(menus);
        JMenuBar mbar = new JMenuBar();
        while (st.hasMoreTokens()) {
            String menuName = st.nextToken();
            mbar.add(GUIUtilities.loadMenu(context, menuName));
        }
        return mbar;
    }

    public static JMenu loadMenu(String name) {
        return GUIUtilities.loadMenu(jEdit.getActionContext(), name);
    }

    public static JMenu loadMenu(ActionContext context, String name) {
        return new EnhancedMenu(name, jEdit.getProperty(name.concat(".label")), context);
    }

    public static JPopupMenu loadPopupMenu(String name, JEditTextArea textArea, MouseEvent evt) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), name, textArea, evt);
    }

    public static JPopupMenu loadPopupMenu(String name) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), name);
    }

    public static JPopupMenu loadPopupMenu(ActionContext context, String name) {
        return GUIUtilities.loadPopupMenu(context, name, null, null);
    }

    public static JPopupMenu loadPopupMenu(ActionContext context, String name, JEditTextArea textArea, MouseEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        String menuItems = jEdit.getProperty(name);
        if (menuItems != null) {
            StringTokenizer st = new StringTokenizer(menuItems);
            while (st.hasMoreTokens()) {
                String menuItemName = st.nextToken();
                if ("-".equals(menuItemName)) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(GUIUtilities.loadMenuItem(context, menuItemName, false));
            }
        }
        if (textArea != null) {
            List<JMenuItem> list = GUIUtilities.getServiceContextMenuItems(textArea, evt);
            if (!list.isEmpty()) {
                menu.addSeparator();
            }
            for (JMenuItem mi : list) {
                menu.add(mi);
            }
        }
        return menu;
    }

    public static List<JMenuItem> getServiceContextMenuItems(JEditTextArea textArea, MouseEvent evt) {
        String[] menuServiceList;
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        String serviceClassName = DynamicContextMenuService.class.getName();
        for (String menuServiceName : menuServiceList = ServiceManager.getServiceNames(serviceClassName)) {
            JMenuItem[] items;
            DynamicContextMenuService dcms;
            if (menuServiceName == null || menuServiceName.trim().isEmpty() || (dcms = (DynamicContextMenuService)ServiceManager.getService(serviceClassName, menuServiceName)) == null || (items = dcms.createMenu(textArea, evt)) == null) continue;
            list.addAll(Arrays.asList(items));
        }
        return list;
    }

    public static JMenuItem loadMenuItem(String name) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), name, true);
    }

    public static JMenuItem loadMenuItem(String name, boolean setMnemonic) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), name, setMnemonic);
    }

    public static JMenuItem loadMenuItem(ActionContext context, String name, boolean setMnemonic) {
        if (name.charAt(0) == '%') {
            return GUIUtilities.loadMenu(context, name.substring(1));
        }
        return GUIUtilities._loadMenuItem(name, context, setMnemonic);
    }

    public static JMenuItem loadMenuItem(EditAction editAction, boolean setMnemonic) {
        String name = editAction.getName();
        ActionContext context = jEdit.getActionContext();
        return GUIUtilities._loadMenuItem(name, context, setMnemonic);
    }

    public static Container loadToolBar(String name) {
        return GUIUtilities.loadToolBar(jEdit.getActionContext(), name);
    }

    public static Container loadToolBar(ActionContext context, String name) {
        JToolBar toolB = new JToolBar();
        toolB.setName(name);
        toolB.setLayout(new FlowLayout(0, 0, 0));
        String buttons = jEdit.getProperty(name);
        if (buttons != null) {
            StringTokenizer st = new StringTokenizer(buttons);
            while (st.hasMoreTokens()) {
                String button = st.nextToken();
                if ("-".equals(button)) {
                    toolB.addSeparator(new Dimension(12, 12));
                    continue;
                }
                EnhancedButton b = GUIUtilities.loadToolButton(context, button);
                toolB.add(b);
            }
        }
        toolB.addSeparator(new Dimension(12, 12));
        return toolB;
    }

    @Nonnull
    public static EnhancedButton loadToolButton(String name) {
        return GUIUtilities.loadToolButton(jEdit.getActionContext(), name);
    }

    @Nonnull
    public static EnhancedButton loadToolButton(ActionContext context, String name) {
        Icon icon;
        String iconName;
        String label = jEdit.getProperty(name + ".label");
        if (label == null) {
            label = name;
        }
        if ((iconName = jEdit.getProperty(name + ".icon")) == null) {
            icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
        } else {
            icon = GUIUtilities.loadIcon(iconName);
            if (icon == null) {
                icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
            }
        }
        Object toolTip = GenericGUIUtilities.prettifyMenuLabel(label);
        String shortcutLabel = GUIUtilities.getShortcutLabel(name, true);
        if (shortcutLabel != null) {
            toolTip = (String)toolTip + " (" + shortcutLabel + ")";
        }
        EnhancedButton b = new EnhancedButton(icon, (String)toolTip, name, context);
        b.setPreferredSize(new Dimension(32, 32));
        return b;
    }

    public static String getPlatformShortcutLabel(String label) {
        if (!OperatingSystem.isMacOSLF() || label == null || label.isEmpty()) {
            return label;
        }
        String[] strokes = label.split(" +");
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < strokes.length; ++i) {
            if (i > 0) {
                out.append(' ');
            }
            out.append(GUIUtilities.getMacShortcutLabel(strokes[i]));
        }
        return out.toString();
    }

    public static String getShortcutLabel(String action, Boolean platform) {
        if (action == null) {
            return null;
        }
        Keymap keymap = jEdit.getKeymapManager().getKeymap();
        String shortcut1 = keymap.getShortcut(action + ".shortcut");
        String shortcut2 = keymap.getShortcut(action + ".shortcut2");
        shortcut1 = platform != false ? GUIUtilities.getPlatformShortcutLabel(shortcut1) : shortcut1;
        String string = shortcut2 = platform != false ? GUIUtilities.getPlatformShortcutLabel(shortcut2) : shortcut2;
        if (shortcut1 == null || shortcut1.isEmpty()) {
            if (shortcut2 == null || shortcut2.isEmpty()) {
                return null;
            }
            return shortcut2;
        }
        if (shortcut2 == null || shortcut2.isEmpty()) {
            return shortcut1;
        }
        return shortcut1 + " or " + shortcut2;
    }

    public static void message(Component comp, String name, Object[] args) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 1);
        } else {
            try {
                EventQueue.invokeAndWait(() -> GUIUtilities.message(comp, name, args));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void error(Component comp, String name, Object[] args) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 0);
        } else {
            try {
                EventQueue.invokeAndWait(() -> GUIUtilities.error(comp, name, args));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String input(Component comp, String name, Object def) {
        return GUIUtilities.input(comp, name, null, def);
    }

    public static String inputProperty(Component comp, String name, String def) {
        return GUIUtilities.inputProperty(comp, name, null, def);
    }

    public static String input(final Component comp, final String name, final Object[] args, final Object def) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return (String)JOptionPane.showInputDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title")), 3, null, null, def);
        }
        final String[] retValue = new String[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    retValue[0] = GUIUtilities.input(comp, name, args, def);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return retValue[0];
    }

    public static String inputProperty(Component comp, String name, Object[] args, String def) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            String retVal = (String)JOptionPane.showInputDialog(comp, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title")), 3, null, null, jEdit.getProperty(def));
            if (retVal != null) {
                jEdit.setProperty(def, retVal);
            }
            return retVal;
        }
        String[] retValue = new String[1];
        try {
            EventQueue.invokeAndWait(() -> {
                retValue[0] = GUIUtilities.inputProperty(comp, name, args, def);
            });
        }
        catch (Exception e) {
            return null;
        }
        return retValue[0];
    }

    public static int confirm(Component comp, String name, Object[] args, int buttons, int type) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showConfirmDialog(comp, jEdit.getProperty(name + ".message", args), jEdit.getProperty(name + ".title"), buttons, type);
        }
        int[] retValue = new int[1];
        try {
            EventQueue.invokeAndWait(() -> {
                retValue[0] = GUIUtilities.confirm(comp, name, args, buttons, type);
            });
        }
        catch (Exception e) {
            return 2;
        }
        return retValue[0];
    }

    public static int option(Component comp, String name, Object[] args, int type, Object[] options, Object initialValue) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showOptionDialog(comp, jEdit.getProperty(name + ".message", args), jEdit.getProperty(name + ".title"), -1, type, null, options, initialValue);
        }
        int[] retValue = new int[1];
        try {
            EventQueue.invokeAndWait(() -> {
                retValue[0] = GUIUtilities.option(comp, name, args, type, options, initialValue);
            });
        }
        catch (Exception e) {
            return 0;
        }
        return retValue[0];
    }

    public static int listConfirm(Component comp, String name, String[] args, Object[] listModel) {
        if (EventQueue.isDispatchThread()) {
            JList<Object> list = new JList<Object>(listModel);
            list.setVisibleRowCount(8);
            Object[] message = new Object[]{jEdit.getProperty(name + ".message", args), new JScrollPane(list)};
            return JOptionPane.showConfirmDialog(comp, message, jEdit.getProperty(name + ".title"), 0, 3);
        }
        int[] retValue = new int[1];
        try {
            EventQueue.invokeAndWait(() -> {
                retValue[0] = GUIUtilities.listConfirm(comp, name, args, listModel);
            });
        }
        catch (Exception e) {
            return 2;
        }
        return retValue[0];
    }

    public static int listConfirm(Component comp, String name, String[] args, Object[] listModel, List selectedItems) {
        if (EventQueue.isDispatchThread()) {
            JList<Object> list = new JList<Object>(listModel);
            list.setSelectionMode(2);
            list.setVisibleRowCount(8);
            list.addSelectionInterval(0, listModel.length - 1);
            Object[] message = new Object[]{jEdit.getProperty(name + ".message", args), new JScrollPane(list)};
            int ret = JOptionPane.showConfirmDialog(comp, message, jEdit.getProperty(name + ".title"), 0, 3);
            selectedItems.addAll(list.getSelectedValuesList());
            return ret;
        }
        int[] retValue = new int[1];
        try {
            EventQueue.invokeAndWait(() -> {
                retValue[0] = GUIUtilities.listConfirm(comp, name, args, listModel, selectedItems);
            });
        }
        catch (Exception e) {
            return 2;
        }
        return retValue[0];
    }

    @Nonnull
    public static String[] showVFSFileDialog(View view, String path, int type, boolean multipleSelection) {
        if (view == null) {
            Log.log(7, GUIUtilities.class, "showVFSFileDialog(): given null view, assuming jEdit.getActiveView()");
            view = jEdit.getActiveView();
        }
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog fileChooser = new VFSFileChooserDialog(view, path, type, multipleSelection);
        return fileChooser.getSelectedFiles();
    }

    @Nonnull
    public static String[] showVFSFileDialog(Dialog parent, View view, String path, int type, boolean multipleSelection) {
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog fileChooser = new VFSFileChooserDialog(parent, view, path, type, multipleSelection, true);
        return fileChooser.getSelectedFiles();
    }

    @Nonnull
    public static String[] showVFSFileDialog(Frame parent, View view, String path, int type, boolean multipleSelection) {
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog fileChooser = new VFSFileChooserDialog(parent, view, path, type, multipleSelection, true);
        return fileChooser.getSelectedFiles();
    }

    public static Font menuAcceleratorFont() {
        if (OperatingSystem.isMacOSLF()) {
            return UIManager.getFont("Menu.acceleratorFont");
        }
        Font font1 = UIManager.getFont("Menu.font");
        if (font1 == null) {
            return new Font("Monospaced", 0, 12);
        }
        Font font2 = new Font("Isabelle DejaVu Sans Mono", 0, font1.getSize());
        FontRenderContext frc = new FontRenderContext(null, true, false);
        float scale = font1.getLineMetrics("", frc).getHeight() / font2.getLineMetrics("", frc).getHeight();
        return new Font(font2.getFamily(), font2.getStyle(), (int)((double)(scale * (float)font1.getSize()) * 0.85));
    }

    public static Color menuAcceleratorForeground(boolean selection) {
        Color color = UIManager.getColor(selection ? "MenuItem.acceleratorSelectionForeground" : "MenuItem.acceleratorForeground");
        if (color == null) {
            color = GUIUtilities.defaultFgColor();
        }
        return color;
    }

    public static boolean isDarkLaf() {
        return FlatLaf.isLafDark();
    }

    public static Color defaultBgColor() {
        return GUIUtilities.isDarkLaf() ? Color.BLACK : Color.WHITE;
    }

    public static Color defaultFgColor() {
        return GUIUtilities.isDarkLaf() ? Color.WHITE : Color.BLACK;
    }

    public static String getTheme() {
        return GUIUtilities.isDarkLaf() ? "dark" : "";
    }

    public static String getThemeSuffix() {
        return GUIUtilities.getThemeSuffix(".");
    }

    public static String getThemeSuffix(String s) {
        String t = GUIUtilities.getTheme();
        return t.isEmpty() ? t : s + t;
    }

    public static String getStyleString(SyntaxStyle style) {
        Font font;
        StringBuilder buf = new StringBuilder();
        if (style.getForegroundColor() != null) {
            buf.append("color:").append(SyntaxUtilities.getColorHexString(style.getForegroundColor()));
        }
        if (style.getBackgroundColor() != null) {
            buf.append(" bgColor:").append(SyntaxUtilities.getColorHexString(style.getBackgroundColor()));
        }
        if (!(font = style.getFont()).isPlain()) {
            buf.append(" style:");
            if (font.isItalic()) {
                buf.append('i');
            }
            if (font.isBold()) {
                buf.append('b');
            }
        }
        return buf.toString();
    }

    public static void loadGeometry(Window win, Container parent, String name) {
        Dimension size = win.getSize();
        int width = jEdit.getIntegerProperty(name + ".width", size.width);
        int height = jEdit.getIntegerProperty(name + ".height", size.height);
        int x = jEdit.getIntegerProperty(name + ".x", 50);
        int y = jEdit.getIntegerProperty(name + ".y", 50);
        if (parent != null) {
            Point location = parent.getLocation();
            x = location.x + x;
            y = location.y + y;
        }
        int extState = jEdit.getIntegerProperty(name + ".extendedState", 0);
        Rectangle desired = new Rectangle(x, y, width, height);
        try {
            if (!Debug.DISABLE_MULTIHEAD) {
                GenericGUIUtilities.adjustForScreenBounds(desired);
            }
        }
        catch (Exception e) {
            Log.log(9, GUIUtilities.class, e);
        }
        if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
            new UnixWorkaround(win, name, desired, extState);
        } else {
            win.setBounds(desired);
            if (win instanceof Frame) {
                ((Frame)win).setExtendedState(extState);
            }
        }
    }

    public static void loadGeometry(Window win, String name) {
        GUIUtilities.loadGeometry(win, win.getParent(), name);
    }

    public static void saveGeometry(Window win, String name) {
        GUIUtilities.saveGeometry(win, win.getParent(), name);
    }

    public static void saveGeometry(Window win, Container parent, String name) {
        if (win instanceof Frame) {
            jEdit.setIntegerProperty(name + ".extendedState", ((Frame)win).getExtendedState());
        }
        Rectangle bounds = win.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        if (parent != null) {
            Rectangle parentBounds = parent.getBounds();
            x -= parentBounds.x;
            y -= parentBounds.y;
        }
        jEdit.setIntegerProperty(name + ".x", x);
        jEdit.setIntegerProperty(name + ".y", y);
        jEdit.setIntegerProperty(name + ".width", bounds.width);
        jEdit.setIntegerProperty(name + ".height", bounds.height);
    }

    public static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static void applyTextAreaColors(Container win) {
        for (Component child : win.getComponents()) {
            child.setBackground(jEdit.getColorProperty("view.bgColor", GUIUtilities.defaultBgColor()));
            child.setForeground(jEdit.getColorProperty("view.fgColor"));
            if (child instanceof JTextPane) {
                ((JTextPane)child).setUI(new BasicEditorPaneUI());
            }
            if (!(child instanceof Container)) continue;
            GUIUtilities.applyTextAreaColors((Container)child);
        }
    }

    public static JComponent createMultilineLabel(String str) {
        int index;
        JPanel panel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int lastOffset = 0;
        while ((index = str.indexOf(10, lastOffset)) != -1) {
            panel.add(new JLabel(str.substring(lastOffset, index)));
            lastOffset = index + 1;
        }
        if (lastOffset != str.length()) {
            panel.add(new JLabel(str.substring(lastOffset)));
        }
        return panel;
    }

    public static Component getComponentParent(Component comp, Class clazz) {
        while (comp != null) {
            Component real;
            if (comp instanceof JComponent && (real = (Component)((JComponent)comp).getClientProperty("KORTE_REAL_FRAME")) != null) {
                comp = real;
            }
            if (clazz.isInstance(comp)) {
                return comp;
            }
            if (comp instanceof JPopupMenu) {
                comp = ((JPopupMenu)comp).getInvoker();
                continue;
            }
            if (comp instanceof FloatingWindowContainer) {
                comp = ((FloatingWindowContainer)comp).getDockableWindowManager();
                continue;
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static View getView(Component comp) {
        return (View)GUIUtilities.getComponentParent(comp, View.class);
    }

    public static void addSizeSaver(@Nonnull Frame frame, @Nonnull String name) {
        GUIUtilities.addSizeSaver(frame, frame.getParent(), name);
    }

    public static void addSizeSaver(@Nonnull Frame frame, Container parent, @Nonnull String name) {
        SizeSaver ss = new SizeSaver(frame, parent, name);
        frame.addWindowStateListener(ss);
        frame.addComponentListener(ss);
    }

    private static void initializeDeprecatedIcons() {
        deprecatedIcons.put("File.png", "16x16/mimetypes/text-x-generic.png");
        deprecatedIcons.put("Folder.png", "16x16/places/folder.png");
        deprecatedIcons.put("OpenFolder.png", "16x16/status/folder-open.png");
        deprecatedIcons.put("OpenFile.png", "16x16/actions/edit-select-all.png");
        deprecatedIcons.put("ReloadSmall.png", "16x16/actions/view-refresh.png");
        deprecatedIcons.put("DriveSmall.png", "16x16/devices/drive-harddisk.png");
        deprecatedIcons.put("New.png", "22x22/actions/document-new.png");
        deprecatedIcons.put("NewDir.png", "22x22/actions/folder-new.png");
        deprecatedIcons.put("Reload.png", "22x22/actions/view-refresh.png");
        deprecatedIcons.put("Load.png", "22x22/places/plugins.png");
        deprecatedIcons.put("Save.png", "22x22/actions/document-save.png");
        deprecatedIcons.put("SaveAs.png", "22x22/actions/document-save-as.png");
        deprecatedIcons.put("SaveAll.png", "22x22/actions/document-save-all.png");
        deprecatedIcons.put("Open.png", "22x22/actions/document-open.png");
        deprecatedIcons.put("Print.png", "22x22/actions/document-print.png");
        deprecatedIcons.put("Drive.png", "22x22/devices/drive-harddisk.png");
        deprecatedIcons.put("Clear.png", "22x22/actions/edit-clear.png");
        deprecatedIcons.put("Run.png", "22x22/actions/application-run.png");
        deprecatedIcons.put("RunAgain.png", "22x22/actions/application-run-again.png");
        deprecatedIcons.put("RunToBuffer.png", "22x22/actions/run-to-buffer.png");
        deprecatedIcons.put("CopyToBuffer.png", "22x22/actions/copy-to-buffer.png");
        deprecatedIcons.put("Plus.png", "22x22/actions/list-add.png");
        deprecatedIcons.put("Minus.png", "22x22/actions/list-remove.png");
        deprecatedIcons.put("Find.png", "22x22/actions/edit-find.png");
        deprecatedIcons.put("FindAgain.png", "22x22/actions/edit-find-next.png");
        deprecatedIcons.put("FindInDir.png", "22x22/actions/edit-find-in-folder.png");
        deprecatedIcons.put("Parse.png", "22x22/actions/document-reload2.png");
        deprecatedIcons.put("Delete.png", "22x22/actions/edit-delete.png");
        deprecatedIcons.put("Paste.png", "22x22/actions/edit-paste.png");
        deprecatedIcons.put("Cut.png", "22x22/actions/edit-cut.png");
        deprecatedIcons.put("Copy.png", "22x22/actions/edit-copy.png");
        deprecatedIcons.put("Undo.png", "22x22/actions/edit-undo.png");
        deprecatedIcons.put("Redo.png", "22x22/actions/edit-redo.png");
        deprecatedIcons.put("CurrentDir.png", "22x22/status/folder-visiting.png");
        deprecatedIcons.put("ParentDir.png", "22x22/actions/go-parent.png");
        deprecatedIcons.put("PageSetup.png", "22x22/actions/printer-setup.png");
        deprecatedIcons.put("Plugins.png", "22x22/apps/system-installer.png");
        deprecatedIcons.put("Floppy.png", "22x22/devices/media-floppy.png");
        deprecatedIcons.put("Stop.png", "22x22/actions/process-stop.png");
        deprecatedIcons.put("Cancel.png", "22x22/actions/process-stop.png");
        deprecatedIcons.put("Home.png", "22x22/actions/go-home.png");
        deprecatedIcons.put("Help.png", "22x22/apps/help-browser.png");
        deprecatedIcons.put("Properties.png", "22x22/actions/document-properties.png");
        deprecatedIcons.put("Preferences.png", "22x22/categories/preferences-system.png");
        deprecatedIcons.put("ZoomIn.png", "22x22/actions/zoom-in.png");
        deprecatedIcons.put("ZoomOut.png", "22x22/actions/zoom-out.png");
        deprecatedIcons.put("BrokenImage.png", "22x22/status/image-missing.png");
        deprecatedIcons.put("AdjustWidth.png", "22x22/actions/resize-horisontal.png");
        deprecatedIcons.put("ToolbarMenu.gif", "ToolbarMenu.gif");
        deprecatedIcons.put("Play.png", "22x22/actions/media-playback-start.png");
        deprecatedIcons.put("Pause.png", "22x22/actions/media-playback-pause.png");
        deprecatedIcons.put("MultipleResults.png", "22x22/actions/edit-find-multiple.png");
        deprecatedIcons.put("SingleResult.png", "22x22/actions/edit-find-single.png");
        deprecatedIcons.put("NextFile.png", "22x22/go-last.png");
        deprecatedIcons.put("PreviousFile.png", "22x22/go-first.png");
        deprecatedIcons.put("closebox.gif", "32x32/actions/process-stop.svg?scale=0.33");
        deprecatedIcons.put("normal.gif", "10x10/status/document-unmodified.png");
        deprecatedIcons.put("readonly.gif", "10x10/emblem/emblem-readonly.png");
        deprecatedIcons.put("dirty.gif", "10x10/status/document-modified.png");
        deprecatedIcons.put("new.gif", "10x10/status/document-new.png");
        deprecatedIcons.put("ArrowU.png", "22x22/actions/go-up.png");
        deprecatedIcons.put("ArrowR.png", "22x22/actions/go-next.png");
        deprecatedIcons.put("ArrowD.png", "22x22/actions/go-down.png");
        deprecatedIcons.put("ArrowL.png", "22x22/actions/go-previous.png");
        deprecatedIcons.put("arrow1.png", "16x16/actions/group-expand.png");
        deprecatedIcons.put("arrow2.png", "16x16/actions/group-collapse.png");
        deprecatedIcons.put("NewView.png", "22x22/actions/window-new.png");
        deprecatedIcons.put("UnSplit.png", "22x22/actions/window-unsplit.png");
        deprecatedIcons.put("SplitVertical.png", "22x22/actions/window-split-vertical.png");
        deprecatedIcons.put("SplitHorizontal.png", "22x22/actions/window-split-horizontal.png");
        deprecatedIcons.put("ButtonProperties.png", "22x22/actions/document-properties.png");
    }

    @Deprecated
    public static boolean isPopupTrigger(MouseEvent evt) {
        return GenericGUIUtilities.isPopupTrigger(evt);
    }

    static void init() {
        GUIUtilities.initializeDeprecatedIcons();
        String theme = jEdit.getProperty("icon-theme", "tango");
        Log.log(1, GUIUtilities.class, "Icon theme set to: " + theme);
        GUIUtilities.setIconPath(defaultIconPath + theme + "/");
        Log.log(1, GUIUtilities.class, "Loading icon theme from: " + iconPath);
    }

    static void showSplashScreen() {
        try {
            SwingUtilities.invokeAndWait(() -> {
                splash = new SplashScreen();
            });
        }
        catch (Exception e) {
            Log.log(9, GUIUtilities.class, "error displaying splash screen !", e);
        }
    }

    static void advanceSplashProgress() {
        if (splash != null) {
            splash.advance();
        }
    }

    static void advanceSplashProgress(String label) {
        if (splash != null) {
            splash.advance(label);
        }
    }

    private static JMenuItem _loadMenuItem(String name, ActionContext context, boolean setMnemonic) {
        Icon itemIcon;
        char mnemonic;
        String label = jEdit.getProperty(name + ".label", name);
        int index = label.indexOf(36);
        if (index != -1 && label.length() - index > 1) {
            mnemonic = Character.toLowerCase(label.charAt(index + 1));
            label = label.substring(0, index).concat(label.substring(++index));
        } else {
            mnemonic = '\u0000';
        }
        JMenuItem mi = jEdit.getBooleanProperty(name + ".toggle") ? new EnhancedCheckBoxMenuItem(label, name, context) : new EnhancedMenuItem(label, name, context);
        if (!OperatingSystem.isMacOS() && setMnemonic && mnemonic != '\u0000') {
            mi.setMnemonic(mnemonic);
        }
        if ((itemIcon = GUIUtilities.loadIcon(jEdit.getProperty(name + ".icon.small"))) != null) {
            mi.setIcon(itemIcon);
        }
        return mi;
    }

    private static String getMacShortcutLabel(String label) {
        String key;
        String text;
        StringBuilder out = new StringBuilder();
        int endOfModifiers = label.indexOf(43);
        if (endOfModifiers != -1) {
            String modifiers = label.substring(0, endOfModifiers).toUpperCase();
            if (modifiers.indexOf(65) != -1) {
                out.append('\u2303');
            }
            if (modifiers.indexOf(77) != -1) {
                out.append('\u2325');
            }
            if (modifiers.indexOf(83) != -1) {
                out.append('\u21e7');
            }
            if (modifiers.indexOf(67) != -1) {
                out.append('\u2318');
            }
        }
        if ((text = macKeySymbols.get(key = label.substring(endOfModifiers + 1))) == null) {
            try {
                int keyCode = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
                text = KeyEvent.getKeyText(keyCode).toUpperCase();
            }
            catch (Exception e) {
                text = key.toUpperCase();
            }
        }
        out.append(text);
        return out.toString();
    }

    private GUIUtilities() {
    }

    static {
        iconPath = defaultIconPath;
        deprecatedIcons = new HashMap<String, String>();
        macKeySymbols = null;
        macKeySymbols = new HashMap();
        macKeySymbols.put("ENTER", "\u21a9");
        macKeySymbols.put("HOME", "\u2196");
        macKeySymbols.put("END", "\u2198");
        macKeySymbols.put("BACK_SPACE", "\u232b");
        macKeySymbols.put("DELETE", "\u2326");
        macKeySymbols.put("PAGE_UP", "\u21de");
        macKeySymbols.put("PAGE_DOWN", "\u21df");
        macKeySymbols.put("LEFT", "\u2190");
        macKeySymbols.put("UP", "\u2191");
        macKeySymbols.put("RIGHT", "\u2192");
        macKeySymbols.put("DOWN", "\u2193");
        macKeySymbols.put("ESCAPE", "\u238b");
        macKeySymbols.put("TAB", "\u21e5");
        macKeySymbols.put("SPACE", "\u2423");
        executorThreadsCounter = new AtomicLong();
        schedExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "SizeSaver-" + executorThreadsCounter.incrementAndGet()));
    }

    public static class UnixWorkaround {
        Window win;
        String name;
        Rectangle desired;
        Rectangle required;
        long start;
        boolean windowOpened;

        public UnixWorkaround(Window win, String name, Rectangle desired, int extState) {
            this.win = win;
            this.name = name;
            this.desired = desired;
            int adjust_x = jEdit.getIntegerProperty(name + ".dx", 0);
            int adjust_y = jEdit.getIntegerProperty(name + ".dy", 0);
            int adjust_width = jEdit.getIntegerProperty(name + ".d-width", 0);
            int adjust_height = jEdit.getIntegerProperty(name + ".d-height", 0);
            this.required = new Rectangle(desired.x - adjust_x, desired.y - adjust_y, desired.width - adjust_width, desired.height - adjust_height);
            Log.log(1, GUIUtilities.class, "Window " + name + ": desired geometry is " + String.valueOf(desired));
            Log.log(1, GUIUtilities.class, "Window " + name + ": setting geometry to " + String.valueOf(this.required));
            this.start = System.currentTimeMillis();
            win.setBounds(this.required);
            if (win instanceof Frame) {
                ((Frame)win).setExtendedState(extState);
            }
            win.addComponentListener(new ComponentHandler());
            win.addWindowListener(new WindowHandler());
        }

        private class ComponentHandler
        extends ComponentAdapter {
            private ComponentHandler() {
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + String.valueOf(UnixWorkaround.this.win.getBounds()));
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle r = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && r.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!r.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + String.valueOf(UnixWorkaround.this.win.getBounds()));
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                UnixWorkaround.this.windowOpened = true;
                Rectangle r = UnixWorkaround.this.win.getBounds();
                Log.log(1, GUIUtilities.class, "Window " + UnixWorkaround.this.name + ": bounds after opening: " + String.valueOf(r));
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dx", r.x - UnixWorkaround.this.required.x);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dy", r.y - UnixWorkaround.this.required.y);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-width", r.width - UnixWorkaround.this.required.width);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-height", r.height - UnixWorkaround.this.required.height);
                UnixWorkaround.this.win.removeWindowListener(this);
            }
        }
    }

    private static class SizeSaver
    extends ComponentAdapter
    implements WindowStateListener {
        private final Frame frame;
        private final Container parent;
        private final String name;
        private Future<?> resizeDelayFuture;

        SizeSaver(@Nonnull Frame frame, Container parent, @Nonnull String name) {
            Objects.requireNonNull(frame);
            Objects.requireNonNull(name);
            this.frame = frame;
            this.parent = parent;
            this.name = name;
        }

        @Override
        public void windowStateChanged(WindowEvent wse) {
            int extendedState = wse.getNewState();
            jEdit.setIntegerProperty(this.name + ".extendedState", extendedState);
            Rectangle bounds = this.frame.getBounds();
            this.save(extendedState, bounds);
        }

        private void save(int extendedState, Rectangle bounds) {
            this.cancelResizeSave();
            switch (extendedState) {
                case 4: {
                    jEdit.setIntegerProperty(this.name + ".x", bounds.x);
                    jEdit.setIntegerProperty(this.name + ".width", bounds.width);
                    break;
                }
                case 2: {
                    jEdit.setIntegerProperty(this.name + ".y", bounds.y);
                    jEdit.setIntegerProperty(this.name + ".height", bounds.height);
                    break;
                }
                case 0: {
                    GUIUtilities.saveGeometry(this.frame, this.parent, this.name);
                }
            }
        }

        private void cancelResizeSave() {
            if (this.resizeDelayFuture != null) {
                this.resizeDelayFuture.cancel(false);
                this.resizeDelayFuture = null;
            }
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            this.componentMoved(ce);
        }

        @Override
        public void componentMoved(ComponentEvent ce) {
            Rectangle bounds = this.frame.getBounds();
            Runnable sizeSaver = () -> EventQueue.invokeLater(() -> this.save(this.frame.getExtendedState(), bounds));
            this.cancelResizeSave();
            this.resizeDelayFuture = schedExecutor.schedule(sizeSaver, 500L, TimeUnit.MILLISECONDS);
        }
    }
}

