/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Text$;
import isabelle.Text$Edit$;
import isabelle.Text$Info$;
import isabelle.Text$Perspective$;
import isabelle.Text$Range$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class Text {

    public static final class Edit {
        private final boolean is_insert;
        private final int start;
        private final String text;

        public static List<Edit> inserts(int n, String string) {
            return Text$Edit$.MODULE$.inserts(n, string);
        }

        public static Edit make(boolean bl, int n, String string) {
            return Text$Edit$.MODULE$.make(bl, n, string);
        }

        public static List<Edit> removes(int n, String string) {
            return Text$Edit$.MODULE$.removes(n, string);
        }

        public static List<Edit> replace(int n, String string, String string2) {
            return Text$Edit$.MODULE$.replace(n, string, string2);
        }

        public Edit(boolean is_insert, int start, String text) {
            this.is_insert = is_insert;
            this.start = start;
            this.text = text;
        }

        public boolean is_insert() {
            return this.is_insert;
        }

        public int start() {
            return this.start;
        }

        public String text() {
            return this.text;
        }

        public String toString() {
            return (this.is_insert() ? "Insert(" : "Remove(") + Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.start()), (Object)BoxesRunTime.boxToInteger((int)this.text().length())).toString() + ")";
        }

        private int transform(boolean do_insert, int i) {
            if (i < this.start()) {
                return i;
            }
            if (do_insert) {
                return i + this.text().length();
            }
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(i - this.text().length()), this.start());
        }

        public int convert(int i) {
            return this.transform(this.is_insert(), i);
        }

        public int revert(int i) {
            return this.transform(!this.is_insert(), i);
        }

        private String insert(int i, String string) {
            return string.substring(0, i) + this.text() + string.substring(i);
        }

        private String remove(int i, int count, String string) {
            return string.substring(0, i) + string.substring(i + count);
        }

        public boolean can_edit(String string, int shift) {
            return shift <= this.start() && this.start() < shift + string.length();
        }

        public Tuple2<Option<Edit>, String> edit(String string, int shift) {
            if (!this.can_edit(string, shift)) {
                return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this), (Object)string);
            }
            if (this.is_insert()) {
                return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)this.insert(this.start() - shift, string));
            }
            int i = this.start() - shift;
            int count = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.text().length()), string.length() - i);
            None$ rest = count == this.text().length() ? None$.MODULE$ : Some$.MODULE$.apply((Object)Text$Edit$.MODULE$.remove(this.start(), this.text().substring(count)));
            return Tuple2$.MODULE$.apply((Object)rest, (Object)this.remove(i, count, string));
        }
    }

    public static class Info<A>
    implements Product,
    Serializable {
        private final Range range;
        private final Object info;

        public static <A> Info<A> apply(Range range, A a) {
            return Text$Info$.MODULE$.apply(range, a);
        }

        public static Info<?> fromProduct(Product product) {
            return Text$Info$.MODULE$.fromProduct(product);
        }

        public static <A> Info<A> unapply(Info<A> info) {
            return Text$Info$.MODULE$.unapply(info);
        }

        public Info(Range range, A info) {
            this.range = range;
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            Range range = this.range();
            Range range2 = info.range();
            if (range == null) {
                if (range2 != null) {
                    return false;
                }
            } else if (!((Object)range).equals(range2)) return false;
            if (!BoxesRunTime.equals(this.info(), info.info())) return false;
            if (!info.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "range";
            }
            if (1 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Range range() {
            return this.range;
        }

        public A info() {
            return (A)this.info;
        }

        public Info<A> restrict(Range r) {
            return Text$Info$.MODULE$.apply(this.range().restrict(r), this.info());
        }

        public Option<Info<A>> try_restrict(Range r) {
            return this.range().try_restrict(r).map((Function1 & Serializable)_$4 -> Text$Info$.MODULE$.apply((Range)_$4, this.info()));
        }

        public <B> Info<B> map(Function1<A, B> f) {
            return Text$Info$.MODULE$.apply(this.range(), f.apply(this.info()));
        }

        public <A> Info<A> copy(Range range, A info) {
            return new Info<A>(range, info);
        }

        public <A> Range copy$default$1() {
            return this.range();
        }

        public <A> A copy$default$2() {
            return this.info();
        }

        public Range _1() {
            return this.range();
        }

        public A _2() {
            return this.info();
        }
    }

    public static final class Perspective {
        private final List ranges;

        public static Perspective apply(List<Range> list) {
            return Text$Perspective$.MODULE$.apply(list);
        }

        public static Perspective empty() {
            return Text$Perspective$.MODULE$.empty();
        }

        public static Perspective full() {
            return Text$Perspective$.MODULE$.full();
        }

        public Perspective(List<Range> ranges) {
            this.ranges = ranges;
        }

        public List<Range> ranges() {
            return this.ranges;
        }

        public boolean is_empty() {
            return this.ranges().isEmpty();
        }

        public Range range() {
            if (this.is_empty()) {
                return Text$Range$.MODULE$.zero();
            }
            return Text$Range$.MODULE$.apply(((Range)this.ranges().head()).start(), ((Range)this.ranges().last()).stop());
        }

        public int hashCode() {
            return this.ranges().hashCode();
        }

        public boolean equals(Object that) {
            Object object = that;
            if (object instanceof Perspective) {
                Perspective other = (Perspective)object;
                List<Range> list = this.ranges();
                List<Range> list2 = other.ranges();
                return !(list != null ? !list.equals(list2) : list2 != null);
            }
            return false;
        }

        public String toString() {
            return this.ranges().toString();
        }
    }

    public static class Range
    implements Product,
    Serializable {
        private final int start;
        private final int stop;

        public static Range apply(int n) {
            return Text$Range$.MODULE$.apply(n);
        }

        public static Range apply(int n, int n2) {
            return Text$Range$.MODULE$.apply(n, n2);
        }

        public static Range fromProduct(Product product) {
            return Text$Range$.MODULE$.fromProduct(product);
        }

        public static Range full() {
            return Text$Range$.MODULE$.full();
        }

        public static Range offside() {
            return Text$Range$.MODULE$.offside();
        }

        public static Range unapply(Range range) {
            return Text$Range$.MODULE$.unapply(range);
        }

        public static Range zero() {
            return Text$Range$.MODULE$.zero();
        }

        public Range(int start, int stop) {
            this.start = start;
            this.stop = stop;
            if (start > stop) {
                package$.MODULE$.error().apply((Object)("Bad range: [" + BoxesRunTime.boxToInteger((int)start).toString() + ".." + BoxesRunTime.boxToInteger((int)stop).toString() + "]"));
            }
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.start());
            n = Statics.mix((int)n, (int)this.stop());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Range)) return false;
            Range range = (Range)object;
            if (this.start() != range.start()) return false;
            if (this.stop() != range.stop()) return false;
            if (!range.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Range;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Range";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "stop";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int start() {
            return this.start;
        }

        public int stop() {
            return this.stop;
        }

        public String toString() {
            return "[" + BoxesRunTime.boxToInteger((int)this.start()).toString() + ".." + BoxesRunTime.boxToInteger((int)this.stop()).toString() + "]";
        }

        public int length() {
            return this.stop() - this.start();
        }

        public Range map(Function1<Object, Object> f) {
            return Text$Range$.MODULE$.apply(f.apply$mcII$sp(this.start()), f.apply$mcII$sp(this.stop()));
        }

        public Range $plus(int i) {
            if (i == 0) {
                return this;
            }
            return this.map((Function1<Object, Object>)((JFunction1.mcII.sp & Serializable)arg_0 -> Text$.isabelle$Text$Range$$_$$plus$$anonfun$1(i, arg_0)));
        }

        public Range $minus(int i) {
            if (i == 0) {
                return this;
            }
            return this.map((Function1<Object, Object>)((JFunction1.mcII.sp & Serializable)arg_0 -> Text$.isabelle$Text$Range$$_$$minus$$anonfun$1(i, arg_0)));
        }

        public boolean is_singularity() {
            return this.start() == this.stop();
        }

        public Range inflate_singularity() {
            if (this.is_singularity()) {
                return Text$Range$.MODULE$.apply(this.start(), this.start() + 1);
            }
            return this;
        }

        public boolean touches(int i) {
            return this.start() <= i && i <= this.stop();
        }

        public boolean contains(int i) {
            return this.start() == i || this.start() < i && i < this.stop();
        }

        public boolean contains(Range that) {
            return this.contains(that.start()) && that.stop() <= this.stop();
        }

        public boolean overlaps(Range that) {
            return this.contains(that.start()) || that.contains(this.start());
        }

        public int compare(Range that) {
            if (this.overlaps(that)) {
                return 0;
            }
            return new RichInt(Predef$.MODULE$.intWrapper(this.start())).compare((Object)BoxesRunTime.boxToInteger((int)that.start()));
        }

        public boolean apart(Range that) {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.start()), that.start()) > RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.stop()), that.stop());
        }

        public Range restrict(Range that) {
            return Text$Range$.MODULE$.apply(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.start()), that.start()), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.stop()), that.stop()));
        }

        public Option<Range> try_restrict(Range that) {
            if (this.apart(that)) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)this.restrict(that));
        }

        public Option<Range> try_join(Range that) {
            if (this.apart(that)) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)Text$Range$.MODULE$.apply(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.start()), that.start()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.stop()), that.stop())));
        }

        public String substring(String text) {
            return text.substring(this.start(), this.stop());
        }

        public Option<String> try_substring(String text) {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)this.substring(text));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Range copy(int start, int stop) {
            return new Range(start, stop);
        }

        public int copy$default$1() {
            return this.start();
        }

        public int copy$default$2() {
            return this.stop();
        }

        public int _1() {
            return this.start();
        }

        public int _2() {
            return this.stop();
        }
    }
}

