/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.MinGW$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.package$;
import isabelle.setup.Environment;
import java.util.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class MinGW {
    private final Option root;

    public static MinGW apply(Path path) {
        return MinGW$.MODULE$.apply(path);
    }

    public static String env_prefix() {
        return MinGW$.MODULE$.env_prefix();
    }

    public static MinGW none() {
        return MinGW$.MODULE$.none();
    }

    public MinGW(Option<Path> root) {
        this.root = root;
    }

    public Option<Path> root() {
        return this.root;
    }

    public String toString() {
        Option<Path> option = this.root();
        if (None$.MODULE$.equals(option)) {
            return "MinGW.none";
        }
        if (option instanceof Some) {
            Path msys_root = (Path)((Some)option).value();
            return "MinGW(" + msys_root.toString() + ")";
        }
        throw new MatchError(option);
    }

    private Option<String> convert_path(String str, String opt) {
        Option<Path> option = this.root();
        if (option instanceof Some) {
            Path msys_root = (Path)((Some)option).value();
            if (Platform$.MODULE$.is_windows()) {
                List<String> command_line = List.of(File$.MODULE$.platform_path(msys_root) + "\\usr\\bin\\cygpath", opt, str);
                Environment.Exec_Result res = Environment.exec_process(command_line, null, null, (boolean)false);
                if (res.ok()) {
                    return Some$.MODULE$.apply((Object)Library$.MODULE$.trim_line(res.out()));
                }
                return (Option)package$.MODULE$.error().apply((Object)("Error: " + package$.MODULE$.quote().apply((Object)Library$.MODULE$.trim_line(res.err()))));
            }
        }
        return None$.MODULE$;
    }

    public String standard_path(String platform_path) {
        return (String)this.convert_path(platform_path, "-u").getOrElse(() -> MinGW.standard_path$$anonfun$1(platform_path));
    }

    public String platform_path(String standard_path) {
        return (String)this.convert_path(standard_path, "-w").getOrElse(() -> MinGW.platform_path$$anonfun$1(standard_path));
    }

    public String bash_script(String script, String env_prefix) {
        Option<Path> option = this.root();
        if (None$.MODULE$.equals(option)) {
            return script;
        }
        if (option instanceof Some) {
            Path msys_root = (Path)((Some)option).value();
            return File$.MODULE$.bash_path(msys_root.$plus(Path$.MODULE$.explode("usr/bin/bash"))) + " -c " + Bash$.MODULE$.string(env_prefix + script);
        }
        throw new MatchError(option);
    }

    public String bash_script$default$2() {
        return MinGW$.MODULE$.env_prefix();
    }

    public Path get_root() {
        if (!Platform$.MODULE$.is_windows()) {
            return (Path)package$.MODULE$.error().apply((Object)"Windows platform required");
        }
        if (this.root().isEmpty()) {
            return (Path)package$.MODULE$.error().apply((Object)"Windows platform requires msys/mingw root specification");
        }
        return (Path)this.root().get();
    }

    public void check() {
        if (Platform$.MODULE$.is_windows()) {
            this.get_root();
            try {
                Predef$.MODULE$.require(Isabelle_System$.MODULE$.bash(this.bash_script("uname -s", this.bash_script$default$2()), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().out().startsWith("MSYS"));
            }
            catch (Throwable throwable) {
                String string;
                Option<String> option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                String msg = string = (String)option.get();
                throw package$.MODULE$.cat_error((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Bad msys/mingw installation " + this.get_root(), msg}));
            }
            return;
        }
    }

    private static final String standard_path$$anonfun$1(String platform_path$1) {
        return File$.MODULE$.standard_path(platform_path$1);
    }

    private static final String platform_path$$anonfun$1(String standard_path$1) {
        return File$.MODULE$.platform_path(standard_path$1);
    }
}

