/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Host;
import isabelle.Host$Info$;
import isabelle.Host$Node_Info$;
import isabelle.Host$Range$;
import isabelle.Host$private_data$;
import isabelle.Host$private_data$Info$;
import isabelle.Host$private_data$Node_Info$;
import isabelle.Isabelle_System$;
import isabelle.Options;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SQL;
import isabelle.SSH;
import isabelle.SSH$Local$;
import isabelle.Value$Int$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Host$
implements Serializable {
    public static final Host$Range$ Range;
    public static final Host$Node_Info$ Node_Info;
    private static final Path numa_info_linux;
    public static final Host$Info$ Info;
    public static final Host$private_data$ private_data;
    public static final Host$ MODULE$;

    private Host$() {
    }

    static {
        MODULE$ = new Host$();
        numa_info_linux = Path$.MODULE$.explode("/sys/devices/system/node/online");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Host$.class);
    }

    public String taskset(List<Object> cpus) {
        return "taskset --cpu-list " + Host$Range$.MODULE$.apply(cpus);
    }

    public boolean taskset_ok(List<Object> cpus) {
        return Isabelle_System$.MODULE$.bash(this.taskset(cpus) + " true", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).ok();
    }

    public String numactl(int node, List<Object> rel_cpus) {
        return "numactl -m" + node + " -N" + node + package$.MODULE$.if_proper(rel_cpus, (Function0<String>)((Function0 & Serializable)() -> Host$.numactl$$anonfun$1(rel_cpus)));
    }

    public List<Object> numactl$default$2() {
        return scala.package$.MODULE$.Nil();
    }

    public boolean numactl_ok(int node, List<Object> rel_cpus) {
        return Isabelle_System$.MODULE$.bash(this.numactl(node, rel_cpus) + " true", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).ok();
    }

    public List<Object> numactl_ok$default$2() {
        return scala.package$.MODULE$.Nil();
    }

    public Options numa_options(Options options, Option<Object> numa_node) {
        Option<Object> option = numa_node;
        if (None$.MODULE$.equals(option)) {
            return options;
        }
        if (option instanceof Some) {
            int node = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return options.string().update("process_policy", this.numactl_ok(node, this.numactl_ok$default$2()) ? this.numactl(node, this.numactl$default$2()) : "");
        }
        throw new MatchError(option);
    }

    public Options node_options(Options options, Host.Node_Info node) {
        Options threads_options = node.rel_cpus().isEmpty() ? options : options.int().update("threads", BoxesRunTime.boxToInteger((int)node.rel_cpus().length()));
        Option<Object> option = node.numa_node();
        if (None$.MODULE$.equals(option) && node.rel_cpus().isEmpty()) {
            return threads_options;
        }
        if (option instanceof Some) {
            int numa_node = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return threads_options.string().update("process_policy", this.numactl_ok(numa_node, node.rel_cpus()) ? this.numactl(numa_node, node.rel_cpus()) : "");
        }
        return threads_options;
    }

    public List<Object> parse_numa_info(String numa_info) {
        Option<List<Object>> option;
        String string = numa_info;
        if (string != null && !(option = Host$Range$.MODULE$.unapply(string)).isEmpty()) {
            List list;
            List nodes = list = (List)option.get();
            return nodes;
        }
        String s = string;
        return (List)package$.MODULE$.error().apply((Object)("Cannot parse CPU NUMA node specification: " + package$.MODULE$.quote().apply((Object)s)));
    }

    public List<Object> numa_nodes(boolean enabled, SSH.System ssh) {
        None$ numa_info = ssh.isabelle_platform().is_linux() ? Some$.MODULE$.apply((Object)numa_info_linux) : None$.MODULE$;
        return (List)numa_info.toList().withFilter((Function1 & Serializable)path -> enabled && ssh.is_file((Path)path)).flatMap((Function1 & Serializable)path -> MODULE$.parse_numa_info(ssh.read((Path)path).trim()).map((Function1)(JFunction1.mcII.sp & Serializable)n -> n));
    }

    public boolean numa_nodes$default$1() {
        return true;
    }

    public SSH.System numa_nodes$default$2() {
        return SSH$Local$.MODULE$;
    }

    public Option<Object> numa_node0() {
        Object object;
        try {
            List<Object> list;
            List<Object> ns = list = this.numa_nodes(this.numa_nodes$default$1(), this.numa_nodes$default$2());
            object = ns.length() >= 2 && this.numactl_ok(BoxesRunTime.unboxToInt((Object)ns.head()), this.numactl_ok$default$2()) ? Some$.MODULE$.apply(ns.head()) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                object = None$.MODULE$;
            }
            throw throwable;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean numa_check(Progress progress, boolean enabled) {
        if (!enabled) return false;
        Option option = this.warning$1();
        if (!(option instanceof Some)) return true;
        String s = (String)((Some)option).value();
        progress.echo_warning("Shuffling of NUMA CPU nodes is disabled: " + s, progress.echo_warning$default$2());
        return false;
    }

    public Option<Object> next_numa_node(SQL.Database db, String hostname, List<Object> available_nodes, Function0<Set<Object>> used_nodes) {
        if (available_nodes.isEmpty()) {
            return None$.MODULE$;
        }
        List available = (List)available_nodes.zipWithIndex();
        Set used = (Set)used_nodes.apply();
        return (Option)Host$private_data$.MODULE$.transaction_lock(db, true, "Host.next_numa_node", Host$private_data$.MODULE$.transaction_lock$default$4(), () -> this.next_numa_node$$anonfun$1(db, hostname, available, used, available_nodes));
    }

    public void write_info(SQL.Database db, Host.Info info) {
        Host$private_data$.MODULE$.transaction_lock(db, true, "Host.write_info", Host$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
            Host$.write_info$$anonfun$2(db, info);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Host.Info> read_info(SQL.Database db, String hostname) {
        return (Option)Host$private_data$.MODULE$.transaction_lock(db, true, "Host.read_info", Host$private_data$.MODULE$.transaction_lock$default$4(), () -> Host$.read_info$$anonfun$2(db, hostname));
    }

    public static final /* synthetic */ Option isabelle$Host$Range$$$_$unapply$$anonfun$1(String x$1, Option x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (string != null) {
                List list;
                Option option2;
                Option<Object> option3;
                String string2;
                List list2;
                Option option4 = Host$Range$.MODULE$.Single().unapplySeq((CharSequence)string);
                if (!option4.isEmpty() && (list2 = (List)option4.get()).lengthCompare(1) == 0 && (string2 = (String)list2.apply(0)) != null && !(option3 = Value$Int$.MODULE$.unapply(string2)).isEmpty()) {
                    int n;
                    int i = n = BoxesRunTime.unboxToInt((Object)option3.get());
                    if (option instanceof Some) {
                        List elems = (List)((Some)option).value();
                        return Some$.MODULE$.apply((Object)elems.$colon$colon((Object)BoxesRunTime.boxToInteger((int)i)));
                    }
                }
                if (!(option2 = Host$Range$.MODULE$.Multiple().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option2.get()).lengthCompare(2) == 0) {
                    Option<Object> option5;
                    String string3 = (String)list.apply(0);
                    String string4 = (String)list.apply(1);
                    if (string3 != null && !(option5 = Value$Int$.MODULE$.unapply(string3)).isEmpty()) {
                        Option<Object> option6;
                        int n;
                        int i = n = BoxesRunTime.unboxToInt((Object)option5.get());
                        if (string4 != null && !(option6 = Value$Int$.MODULE$.unapply(string4)).isEmpty()) {
                            int n2;
                            int j = n2 = BoxesRunTime.unboxToInt((Object)option6.get());
                            if (option instanceof Some) {
                                List elems = (List)((Some)option).value();
                                List list3 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(i), j).toList();
                                return Some$.MODULE$.apply((Object)elems.$colon$colon$colon(list3));
                            }
                        }
                    }
                }
            }
        }
        return None$.MODULE$;
    }

    private static final String numactl$$anonfun$1(List rel_cpus$1) {
        return " -C+" + Host$Range$.MODULE$.apply((List<Object>)rel_cpus$1);
    }

    private final Option warning$1() {
        List<Object> list = this.numa_nodes(this.numa_nodes$default$1(), this.numa_nodes$default$2());
        List<Object> ns = list;
        if (ns.length() < 2) {
            return Some$.MODULE$.apply((Object)"no NUMA nodes available");
        }
        List<Object> ns2 = list;
        if (!this.numactl_ok(BoxesRunTime.unboxToInt((Object)ns2.head()), this.numactl_ok$default$2())) {
            return Some$.MODULE$.apply((Object)"bad numactl tool");
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ int isabelle$Host$private_data$$$_$read_numa_next$$anonfun$1(SQL.Result res) {
        return res.int(Host$private_data$Node_Info$.MODULE$.numa_next());
    }

    public static final int isabelle$Host$private_data$$$_$read_numa_next$$anonfun$2() {
        return 0;
    }

    public static final /* synthetic */ void isabelle$Host$private_data$$$_$write_numa_next$$anonfun$1(String hostname$1, int numa_next$1, SQL.Statement stmt) {
        stmt.string().update(1, hostname$1);
        stmt.int().update(2, numa_next$1);
    }

    public static final /* synthetic */ void isabelle$Host$private_data$$$_$write_info$$anonfun$1(Host.Info info$1, SQL.Statement stmt) {
        stmt.string().update(1, info$1.hostname());
        stmt.string().update(2, info$1.numa_nodes().mkString(","));
        stmt.int().update(3, info$1.num_cpus());
        stmt.double().update(4, info$1.benchmark_score());
    }

    public static final /* synthetic */ Host.Info isabelle$Host$private_data$$$_$read_info$$anonfun$1(String hostname$2, SQL.Result res) {
        String numa_info = res.string(Host$private_data$Info$.MODULE$.numa_info());
        int num_cpus = res.int(Host$private_data$Info$.MODULE$.num_cpus());
        Option<Object> benchmark_score = res.get_double(Host$private_data$Info$.MODULE$.benchmark_score());
        return Host$Info$.MODULE$.apply(hostname$2, MODULE$.parse_numa_info(numa_info), num_cpus, benchmark_score);
    }

    private static final int $anonfun$2() {
        return 0;
    }

    private static final Option $anonfun$4(List candidates$1, Set used$3) {
        return candidates$1.find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n = tuple2._1$mcI$sp();
                return !used$3.apply$mcZI$sp(n);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Tuple2 $anonfun$5(List candidates$2) {
        return (Tuple2)candidates$2.head();
    }

    private final Some next_numa_node$$anonfun$1(SQL.Database db$1, String hostname$3, List available$1, Set used$1, List available_nodes$1) {
        int numa_next = Host$private_data$.MODULE$.read_numa_next(db$1, hostname$3);
        int numa_index = BoxesRunTime.unboxToInt((Object)available$1.collectFirst((PartialFunction)new Serializable(numa_next){
            private final int numa_next$2;
            {
                this.numa_next$2 = numa_next$3;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    int n = tuple2._1$mcI$sp();
                    int i = tuple2._2$mcI$sp();
                    if (n == this.numa_next$2) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (n == this.numa_next$2) {
                        return BoxesRunTime.boxToInteger((int)i);
                    }
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(Host$::$anonfun$2));
        List list = (List)available$1.drop(numa_index);
        List candidates = available$1.take(numa_index).$colon$colon$colon(list);
        Tuple2 tuple2 = (Tuple2)candidates.find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n = tuple2._1$mcI$sp();
                int i = tuple2._2$mcI$sp();
                return i == numa_index && !used$1.apply$mcZI$sp(n);
            }
            throw new MatchError((Object)tuple2);
        }).orElse(() -> Host$.$anonfun$4(candidates, used$1)).getOrElse(() -> Host$.$anonfun$5(candidates));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = tuple2._1$mcI$sp();
        int i = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(n, i);
        int n2 = sp2._1$mcI$sp();
        int i2 = sp2._2$mcI$sp();
        int numa_next1 = BoxesRunTime.unboxToInt((Object)available_nodes$1.apply((i2 + 1) % available_nodes$1.length()));
        if (numa_next != numa_next1) {
            Host$private_data$.MODULE$.write_numa_next(db$1, hostname$3, numa_next1);
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n2));
    }

    private static final void write_info$$anonfun$2(SQL.Database db$2, Host.Info info$2) {
        Host$private_data$.MODULE$.write_info(db$2, info$2);
    }

    private static final Option read_info$$anonfun$2(SQL.Database db$3, String hostname$4) {
        return Host$private_data$.MODULE$.read_info(db$3, hostname$4);
    }
}

