/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Build_History$Multicore$;
import isabelle.Build_Log;
import isabelle.Build_Log$;
import isabelle.Build_Log$Log_File$;
import isabelle.Build_Log$Prop$;
import isabelle.Bytes;
import isabelle.Command_Line$;
import isabelle.Components$;
import isabelle.Compress$Options_XZ$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date;
import isabelle.File$;
import isabelle.File_Progress;
import isabelle.File_Progress$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Markup$;
import isabelle.Mercurial;
import isabelle.Mercurial$Hg_Sync$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Other_Isabelle;
import isabelle.Other_Isabelle$;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform;
import isabelle.Platform$;
import isabelle.Platform$Family$;
import isabelle.Process_Result;
import isabelle.Process_Result$RC$;
import isabelle.Progress;
import isabelle.Properties$;
import isabelle.Protocol$;
import isabelle.Protocol_Message$;
import isabelle.Rsync;
import isabelle.Rsync$Context$;
import isabelle.SHA1;
import isabelle.SQL;
import isabelle.SQLite$;
import isabelle.SSH;
import isabelle.Setup_Tool$;
import isabelle.Store;
import isabelle.Store$;
import isabelle.Sync;
import isabelle.Sync$;
import isabelle.Value$Int$;
import isabelle.Value$Long$;
import isabelle.package$;
import java.io.Serializable;
import java.sql.SQLException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Build_History$
implements Serializable {
    private static final String engine;
    private static final String log_prefix;
    private static final Tuple2<Object, Object> default_multicore;
    private static final int default_heap;
    private static final String default_isabelle_identifier;
    private static final Build_History$Multicore$ Multicore;
    public static final Build_History$ MODULE$;

    private Build_History$() {
    }

    static {
        MODULE$ = new Build_History$();
        engine = "build_history";
        log_prefix = MODULE$.engine() + "_";
        default_multicore = new Tuple2.mcII.sp(1, 1);
        default_heap = 1500;
        default_isabelle_identifier = "build_history";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Build_History$.class);
    }

    public String engine() {
        return engine;
    }

    public String log_prefix() {
        return log_prefix;
    }

    public String make_64_32(String platform) {
        return platform.replace("x86_64-", "x86_64_32-").replace("arm64-", "arm64_32-");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String augment_settings(Other_Isabelle other_isabelle, int threads, boolean arch_64, boolean arch_apple, int heap, Option<Object> max_heap, List<String> more_settings) {
        String string;
        String cygwin_32 = "x86-cygwin";
        String windows_32 = "x86-windows";
        String windows_64 = "x86_64-windows";
        String windows_64_32 = "x86_64_32-windows";
        String platform_32 = other_isabelle.getenv("ISABELLE_PLATFORM32");
        String platform_64 = other_isabelle.getenv("ISABELLE_PLATFORM64");
        String platform_64_32 = this.make_64_32(platform_64);
        String platform_apple_64 = other_isabelle.getenv("ISABELLE_APPLE_PLATFORM64");
        String platform_apple_64_32 = this.make_64_32(platform_apple_64);
        Path polyml_home = other_isabelle.ml_settings().polyml_home();
        if (Platform$.MODULE$.is_windows() && arch_64) {
            if (!this.check_dir$1(polyml_home, windows_64)) throw this.err$1(windows_64);
            string = windows_64;
        } else if (Platform$.MODULE$.is_windows() && !arch_64) {
            if (this.check_dir$1(polyml_home, windows_64_32)) {
                string = windows_64_32;
            } else if (this.check_dir$1(polyml_home, cygwin_32)) {
                string = cygwin_32;
            } else {
                if (!this.check_dir$1(polyml_home, windows_32)) throw this.err$1(windows_32);
                string = windows_32;
            }
        } else if (arch_apple && arch_64) {
            if (!this.check_dir$1(polyml_home, platform_apple_64)) throw this.err$1(platform_apple_64);
            string = platform_apple_64;
        } else if (arch_apple) {
            if (!this.check_dir$1(polyml_home, platform_apple_64_32)) throw this.err$1(platform_apple_64_32);
            string = platform_apple_64_32;
        } else if (arch_64) {
            if (!this.check_dir$1(polyml_home, platform_64)) throw this.err$1(platform_64);
            string = platform_64;
        } else {
            string = this.check_dir$1(polyml_home, platform_64_32) ? platform_64_32 : platform_32;
        }
        String ml_platform = string;
        String ml_options = "--minheap " + heap + (String)(max_heap.isDefined() ? " --maxheap " + max_heap.get() : "") + " --gcthreads " + threads + (ml_platform.endsWith("-windows") ? " --codepage utf8" : "");
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)ml_platform, (Object)new .colon.colon((Object)("ML_HOME=" + File$.MODULE$.bash_path(this.ml_home$1(polyml_home, ml_platform))), (List)new .colon.colon((Object)("ML_PLATFORM=" + package$.MODULE$.quote().apply((Object)ml_platform)), (List)new .colon.colon((Object)("ML_OPTIONS=" + package$.MODULE$.quote().apply((Object)ml_options)), (List)Nil$.MODULE$))));
        String ml_platform2 = (String)tuple2._1();
        List ml_settings = (List)tuple2._2();
        List thread_settings = (List)new .colon.colon((Object)("ISABELLE_JAVA_SYSTEM_OPTIONS=\"$ISABELLE_JAVA_SYSTEM_OPTIONS -Disabelle.threads=" + threads + "\""), (List)new .colon.colon((Object)("ISABELLE_BUILD_OPTIONS=\"threads=" + threads + "\""), (List)Nil$.MODULE$));
        List list = (List)new .colon.colon((Object)ml_settings, (List)new .colon.colon((Object)thread_settings, (List)Nil$.MODULE$));
        List settings = (more_settings.isEmpty() ? scala.package$.MODULE$.Nil() : (List)new .colon.colon(more_settings, (List)Nil$.MODULE$)).$colon$colon$colon(list);
        File$.MODULE$.append(other_isabelle.etc_settings(), "\n" + package$.MODULE$.cat_lines().apply((Object)settings.map((Function1 & Serializable)_$1 -> (String)package$.MODULE$.terminate_lines().apply(_$1))));
        return ml_platform2;
    }

    public List<Tuple2<Process_Result, Path>> local_build(Options options, Path root, Progress progress, boolean afp, String isabelle_identifier, int ml_statistics_step, String component_repository, String components_base, Option<List<Platform.Family>> clean_platforms, boolean clean_archives, boolean fresh, String hostname, boolean multicore_base, List<Tuple2<Object, Object>> multicore_list, boolean arch_64, boolean arch_apple, int heap, Option<Object> max_heap, List<String> more_settings, List<String> more_preferences, boolean verbose, List<String> build_tags, List<String> build_args) {
        String string;
        if (File$.MODULE$.eq(Path$.MODULE$.ISABELLE_HOME(), root)) {
            package$.MODULE$.error().apply((Object)("Repository coincides with ISABELLE_HOME=" + Path$.MODULE$.ISABELLE_HOME().expand()));
        }
        multicore_list.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                return threads < 1;
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                throw (Nothing$)package$.MODULE$.error().apply((Object)("Bad threads value < 1: " + threads));
            }
            throw new MatchError((Object)tuple2);
        });
        multicore_list.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int processes = tuple2._2$mcI$sp();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int processes = tuple2._2$mcI$sp();
                return processes < 1;
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int processes = tuple2._2$mcI$sp();
                throw (Nothing$)package$.MODULE$.error().apply((Object)("Bad processes value < 1: " + processes));
            }
            throw new MatchError((Object)tuple2);
        });
        if (heap < 100) {
            package$.MODULE$.error().apply((Object)("Bad heap value < 100: " + heap));
        }
        if (max_heap.isDefined() && BoxesRunTime.unboxToInt((Object)max_heap.get()) < heap) {
            package$.MODULE$.error().apply((Object)("Bad max_heap value < heap: " + max_heap.get()));
        }
        if ((string = System.getenv("ISABELLE_SETTINGS_PRESENT")) != null && !"".equals(string)) {
            package$.MODULE$.error().apply((Object)"Cannot run Admin/build_other within existing Isabelle settings environment");
        }
        Mercurial.Hg_Sync.Directory isabelle_directory = this.directory$1(verbose, progress, root);
        Tuple2 tuple2 = afp ? Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this.directory$1(verbose, progress, root.$plus(Path$.MODULE$.explode("dirs/AFP")))), (Object)new .colon.colon((Object)"-d", (List)new .colon.colon((Object)"~~/dirs/AFP/thys", (List)Nil$.MODULE$))) : Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)scala.package$.MODULE$.Nil());
        Option afp_directory = (Option)tuple2._1();
        List afp_build_args = (List)tuple2._2();
        Other_Isabelle other_isabelle = Other_Isabelle$.MODULE$.apply(root, isabelle_identifier, Other_Isabelle$.MODULE$.apply$default$3(), progress);
        String build_host = (String)((Option)package$.MODULE$.proper_string().apply((Object)hostname)).getOrElse(Build_History$::$anonfun$1);
        Date build_history_date = progress.now();
        String build_group_id = build_host + ":" + build_history_date.time();
        BooleanRef first_build = BooleanRef.create((boolean)true);
        return (List)multicore_list.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                int processes = tuple2._2$mcI$sp();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int threads = tuple2._1$mcI$sp();
                int processes = tuple2._2$mcI$sp();
                List<String> component_settings = other_isabelle.init_components(components_base, Components$.MODULE$.optional_catalogs(), other_isabelle.init_components$default$3());
                other_isabelle.init_settings(component_settings);
                this.resolve_components$1(other_isabelle, verbose, clean_platforms, clean_archives, component_repository);
                String ml_platform = this.augment_settings(other_isabelle, threads, arch_64, arch_apple, heap, max_heap, more_settings);
                File$.MODULE$.write(other_isabelle.etc_preferences(), (String)package$.MODULE$.cat_lines().apply((Object)more_preferences.$colon$colon((Object)"build_log_verbose = true")));
                Path isabelle_output = other_isabelle.user_output_dir();
                Path isabelle_output_log = isabelle_output.$plus(Path$.MODULE$.explode("log"));
                Path isabelle_base_log = isabelle_output.$plus(Path$.MODULE$.explode("../base_log"));
                if (first_build$1.elem) {
                    this.resolve_components$1(other_isabelle, verbose, clean_platforms, clean_archives, component_repository);
                    other_isabelle.scala_build(fresh, verbose);
                    Setup_Tool$.MODULE$.init(other_isabelle, verbose);
                    Isabelle_System$.MODULE$.rm_tree(isabelle_base_log);
                }
                Isabelle_System$.MODULE$.rm_tree(isabelle_output);
                Isabelle_System$.MODULE$.make_directory(isabelle_output);
                other_isabelle.expand_path(Path$.MODULE$.explode("$ISABELLE_HOME_USER/mash_state")).file().delete();
                List list = (List)new .colon.colon((Object)build_host, (List)new .colon.colon((Object)ml_platform, (List)new .colon.colon((Object)("M" + threads), (List)Nil$.MODULE$)));
                Path log_path = other_isabelle.isabelle_home_user().$plus(Build_Log$.MODULE$.log_subdir(build_history_date)).$plus(Build_Log$.MODULE$.log_filename(this.engine(), build_history_date, (List<String>)build_tags.$colon$colon$colon(list)));
                Isabelle_System$.MODULE$.make_directory(log_path.dir());
                Path build_out = other_isabelle.expand_path(Path$.MODULE$.explode("$ISABELLE_HOME_USER/log/build.out"));
                File_Progress build_out_progress = new File_Progress(build_out, File_Progress$.MODULE$.$lessinit$greater$default$2());
                build_out.file().delete();
                if (multicore_base && !first_build$1.elem && isabelle_base_log.is_dir()) {
                    Isabelle_System$.MODULE$.copy_dir(isabelle_base_log, isabelle_output_log, Isabelle_System$.MODULE$.copy_dir$default$3());
                }
                Date build_start = progress.now();
                List list2 = (List)new .colon.colon((Object)"-v", (List)new .colon.colon((Object)("-j" + processes), (List)Nil$.MODULE$));
                List build_args1 = build_args.$colon$colon$colon(afp_build_args).$colon$colon$colon(list2);
                Other_Isabelle other_Isabelle = Other_Isabelle$.MODULE$.apply(root, isabelle_identifier, Other_Isabelle$.MODULE$.apply$default$3(), build_out_progress);
                String string = "bin/isabelle build " + Bash$.MODULE$.strings((Iterable<String>)build_args1);
                Path path = other_Isabelle.bash$default$2();
                String string2 = other_Isabelle.bash$default$3();
                Process_Result build_result = other_Isabelle.bash(string, path, string2, true, true, false);
                Date build_end = progress.now();
                Store store = Store$.MODULE$.apply(options.$plus("build_database_server=false"), Store$.MODULE$.apply$default$2(), Store$.MODULE$.apply$default$3(), Store$.MODULE$.apply$default$4());
                Build_Log.Build_Info build_info = Build_Log$Log_File$.MODULE$.apply(log_path.file_name(), build_result.out_lines(), store.cache()).parse_build_info(true);
                List<Tuple2<String, String>> list3 = Properties$.MODULE$.lines_nonempty(Build_Log$Prop$.MODULE$.build_tags().name(), build_tags);
                List<Tuple2<String, String>> list4 = Properties$.MODULE$.lines_nonempty(Build_Log$Prop$.MODULE$.build_args().name(), (List<String>)build_args1);
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_group_id().name());
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_id().name());
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_engine().name());
                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_host().name());
                String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_start().name());
                String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.build_end().name());
                String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.isabelle_version().name());
                List list5 = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)build_group_id), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)(build_host + ":" + build_start.time())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)this.engine()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)build_host), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)Build_Log$.MODULE$.print_date(build_start)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)Build_Log$.MODULE$.print_date(build_end)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)isabelle_directory.id()), (List)Nil$.MODULE$)))))));
                List meta_info = afp_directory.map((Function1 & Serializable)dir -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$Prop$.MODULE$.afp_version().name());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)dir.id());
                }).toList().$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3);
                build_out_progress.echo("Reading session build info ...", build_out_progress.echo$default$2());
                List session_build_info = build_info.finished_sessions().flatMap((Function1 & Serializable)session_name -> {
                    Path database = isabelle_output.$plus(Store$.MODULE$.log_db((String)session_name));
                    if (database.is_file()) {
                        return (IterableOnce)package$.MODULE$.using(SQLite$.MODULE$.open_database(database, SQLite$.MODULE$.open_database$default$2()), (Function1 & Serializable)db -> {
                            SHA1.Shasum sources;
                            List list;
                            try {
                                list = store.read_theory_timings((SQL.Database)db, (String)session_name).map((Function1 & Serializable)ps -> {
                                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)Build_Log$.MODULE$.SESSION_NAME(), session_name);
                                    return Protocol$.MODULE$.Theory_Timing_Marker().apply((List<Tuple2<String, String>>)ps.$colon$colon((Object)tuple2));
                                });
                            }
                            catch (Throwable throwable) {
                                Option<String> option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                                    String string = (String)option.get();
                                    list = scala.package$.MODULE$.Nil();
                                }
                                throw throwable;
                            }
                            List theory_timings = list;
                            Option option = store.read_build((SQL.Database)db, (String)session_name).map((Function1 & Serializable)_$2 -> _$2.sources());
                            Nil$ session_sources = option instanceof Some && !(sources = (SHA1.Shasum)((Some)option).value()).is_empty() ? (List)new .colon.colon((Object)("Sources " + session_name + " " + sources.digest().toString()), (List)Nil$.MODULE$) : scala.package$.MODULE$.Nil();
                            return session_sources.$colon$colon$colon(theory_timings);
                        });
                    }
                    return scala.package$.MODULE$.Nil();
                });
                build_out_progress.echo("Reading ML statistics ...", build_out_progress.echo$default$2());
                List ml_statistics = build_info.finished_sessions().flatMap((Function1 & Serializable)session_name -> {
                    List<List<Tuple2<String, String>>> properties;
                    Path database = isabelle_output.$plus(Store$.MODULE$.log_db((String)session_name));
                    Path log_gz = isabelle_output.$plus(Store$.MODULE$.log_gz((String)session_name));
                    if (database.is_file()) {
                        v0 = (List)package$.MODULE$.using(SQLite$.MODULE$.open_database(database, SQLite$.MODULE$.open_database$default$2()), (Function1 & Serializable)_$3 -> store.read_ml_statistics((SQL.Database)_$3, (String)session_name));
                    } else if (log_gz.is_file()) {
                        Build_Log.Log_File log_File = Build_Log$Log_File$.MODULE$.read(log_gz.file(), store.cache());
                        v0 = log_File.parse_session_info(log_File.parse_session_info$default$1(), log_File.parse_session_info$default$2(), true, log_File.parse_session_info$default$4()).ml_statistics();
                    } else {
                        v0 = properties = scala.package$.MODULE$.Nil();
                    }
                    Nil$ trimmed_properties = ml_statistics_step <= 0 ? scala.package$.MODULE$.Nil() : (ml_statistics_step == 1 ? properties : properties.iterator().zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            List ps = (List)tuple2._1();
                            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            return true;
                        }
                        return false;
                    }).withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            List ps = (List)tuple2._1();
                            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            return i % ml_statistics_step == 0;
                        }
                        throw new MatchError((Object)tuple2);
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            List ps = (List)tuple2._1();
                            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            return ps;
                        }
                        throw new MatchError((Object)tuple2);
                    }).toList());
                    return trimmed_properties.map((Function1 & Serializable)ps -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$.MODULE$.SESSION_NAME());
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, session_name);
                        return ps.$colon$colon((Object)tuple2);
                    });
                });
                build_out_progress.echo("Reading error messages ...", build_out_progress.echo$default$2());
                List session_errors = build_info.failed_sessions().flatMap((Function1 & Serializable)session_name -> {
                    Nil$ nil$;
                    Path database = isabelle_output.$plus(Store$.MODULE$.log_db((String)session_name));
                    if (database.is_file()) {
                        try {
                            nil$ = (List)package$.MODULE$.using(SQLite$.MODULE$.open_database(database, SQLite$.MODULE$.open_database$default$2()), (Function1 & Serializable)_$4 -> store.read_errors((SQL.Database)_$4, (String)session_name));
                        }
                        catch (SQLException sQLException) {
                            nil$ = scala.package$.MODULE$.Nil();
                        }
                    } else {
                        nil$ = scala.package$.MODULE$.Nil();
                    }
                    Nil$ errors = nil$;
                    return errors.map((Function1 & Serializable)msg -> {
                        String content = Library$.MODULE$.encode_lines(Protocol_Message$.MODULE$.clean_output((String)msg));
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)Build_Log$.MODULE$.SESSION_NAME());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)Markup$.MODULE$.CONTENT());
                        return (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, session_name), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)content), (List)Nil$.MODULE$));
                    });
                });
                build_out_progress.echo("Reading heap sizes ...", build_out_progress.echo$default$2());
                List heap_sizes = build_info.finished_sessions().flatMap((Function1 & Serializable)session_name -> {
                    Path heap = isabelle_output.$plus(Path$.MODULE$.explode((String)session_name));
                    if (heap.is_file()) {
                        return Some$.MODULE$.apply((Object)("Heap " + session_name + " (" + Value$Long$.MODULE$.apply(File$.MODULE$.size(heap)) + " bytes)"));
                    }
                    return None$.MODULE$;
                });
                build_out_progress.echo("Writing log file " + log_path.xz() + " ...", build_out_progress.echo$default$2());
                String string10 = Protocol$.MODULE$.Meta_Info_Marker().apply((List<Tuple2<String, String>>)meta_info);
                List list6 = ml_statistics.map((Function1 & Serializable)props -> Protocol$.MODULE$.ML_Statistics_Marker().apply((List<Tuple2<String, String>>)props));
                List list7 = session_errors.map((Function1 & Serializable)props -> Protocol$.MODULE$.Error_Message_Marker().apply((List<Tuple2<String, String>>)props));
                File$.MODULE$.write_xz(log_path.xz(), (String)package$.MODULE$.terminate_lines().apply((Object)heap_sizes.$colon$colon$colon(list7).$colon$colon$colon(list6).$colon$colon$colon(session_build_info).$colon$colon$colon(build_result.out_lines()).$colon$colon((Object)string10)), Compress$Options_XZ$.MODULE$.apply(6));
                if (multicore_base && first_build$1.elem && isabelle_output_log.is_dir()) {
                    Isabelle_System$.MODULE$.copy_dir(isabelle_output_log, isabelle_base_log, Isabelle_System$.MODULE$.copy_dir$default$3());
                }
                Isabelle_System$.MODULE$.rm_tree(isabelle_output);
                first_build$1.elem = false;
                return Tuple2$.MODULE$.apply((Object)build_result, (Object)log_path.xz());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Progress local_build$default$3() {
        return new Progress();
    }

    public boolean local_build$default$4() {
        return false;
    }

    public String local_build$default$5() {
        return default_isabelle_identifier;
    }

    public int local_build$default$6() {
        return 1;
    }

    public String local_build$default$7() {
        return Components$.MODULE$.static_component_repository();
    }

    public String local_build$default$8() {
        return Components$.MODULE$.dynamic_components_base();
    }

    public Option<List<Platform.Family>> local_build$default$9() {
        return None$.MODULE$;
    }

    public boolean local_build$default$10() {
        return false;
    }

    public boolean local_build$default$11() {
        return false;
    }

    public String local_build$default$12() {
        return "";
    }

    public boolean local_build$default$13() {
        return false;
    }

    public List<Tuple2<Object, Object>> local_build$default$14() {
        return (List)new .colon.colon(default_multicore, (List)Nil$.MODULE$);
    }

    public boolean local_build$default$15() {
        return false;
    }

    public boolean local_build$default$16() {
        return false;
    }

    public int local_build$default$17() {
        return default_heap;
    }

    public Option<Object> local_build$default$18() {
        return None$.MODULE$;
    }

    public List<String> local_build$default$19() {
        return scala.package$.MODULE$.Nil();
    }

    public List<String> local_build$default$20() {
        return scala.package$.MODULE$.Nil();
    }

    public boolean local_build$default$21() {
        return false;
    }

    public List<String> local_build$default$22() {
        return scala.package$.MODULE$.Nil();
    }

    public List<String> local_build$default$23() {
        return scala.package$.MODULE$.Nil();
    }

    public void main(String[] args) {
        Command_Line$.MODULE$.tool((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Build_History$.main$$anonfun$1(args);
            return BoxedUnit.UNIT;
        });
    }

    public List<Tuple2<String, Bytes>> remote_build(SSH.Session ssh, Path isabelle_self, Path isabelle_other, String isabelle_identifier, String component_repository, String components_base, boolean clean_platform, boolean clean_archives, boolean shared_isabelle_self, Progress progress, String rev, Option<Path> afp_repos, String afp_rev, String options, String args, boolean no_build) {
        if (!shared_isabelle_self) {
            this.sync$1(progress, ssh, afp_repos, isabelle_self, this.sync$default$2$1(), this.sync$default$3$1(), this.sync$default$4$1(), this.sync$default$5$1());
        }
        Other_Isabelle self_isabelle = Other_Isabelle$.MODULE$.apply(isabelle_self, isabelle_identifier, ssh, progress);
        None$ clean_platforms = clean_platform ? Some$.MODULE$.apply((Object)new .colon.colon((Object)ssh.isabelle_platform_family(), (List)Nil$.MODULE$)) : None$.MODULE$;
        boolean bl = !shared_isabelle_self;
        List<String> list = self_isabelle.init_components(components_base, self_isabelle.init_components$default$2(), self_isabelle.init_components$default$3());
        self_isabelle.init(list, bl, true, (Option<List<Platform.Family>>)clean_platforms, clean_archives, component_repository);
        this.sync$1(progress, ssh, afp_repos, isabelle_other, true, (String)((Option)package$.MODULE$.proper_string().apply((Object)rev)).getOrElse(Build_History$::remote_build$$anonfun$1), (String)((Option)package$.MODULE$.proper_string().apply((Object)afp_rev)).getOrElse(Build_History$::remote_build$$anonfun$2), true);
        if (no_build) {
            return scala.package$.MODULE$.Nil();
        }
        return (List)ssh.with_tmp_dir(arg_0 -> Build_History$.remote_build$$anonfun$3(afp_repos, options, ssh, component_repository, components_base, (Option)clean_platforms, clean_archives, isabelle_other, args, self_isabelle, arg_0));
    }

    public String remote_build$default$4() {
        return "remote_build_history";
    }

    public String remote_build$default$5() {
        return Components$.MODULE$.static_component_repository();
    }

    public String remote_build$default$6() {
        return Components$.MODULE$.dynamic_components_base();
    }

    public boolean remote_build$default$7() {
        return false;
    }

    public boolean remote_build$default$8() {
        return false;
    }

    public boolean remote_build$default$9() {
        return false;
    }

    public Progress remote_build$default$10() {
        return new Progress();
    }

    public String remote_build$default$11() {
        return "";
    }

    public Option<Path> remote_build$default$12() {
        return None$.MODULE$;
    }

    public String remote_build$default$13() {
        return "";
    }

    public String remote_build$default$14() {
        return "";
    }

    public String remote_build$default$15() {
        return "";
    }

    public boolean remote_build$default$16() {
        return false;
    }

    private final Path ml_home$1(Path polyml_home$1, String platform) {
        return polyml_home$1.$plus(Path$.MODULE$.explode(platform));
    }

    private final Nothing$ err$1(String platform) {
        return (Nothing$)package$.MODULE$.error().apply((Object)("Platform " + platform + " unavailable on this machine"));
    }

    private final boolean check_dir$1(Path polyml_home$2, String platform) {
        String string = platform;
        String string2 = "";
        return (string == null ? string2 != null : !string.equals(string2)) && this.ml_home$1(polyml_home$2, platform).is_dir();
    }

    private final Mercurial.Hg_Sync.Directory directory$1(boolean verbose$1, Progress progress$1, Path dir) {
        Mercurial.Hg_Sync.Directory directory = Mercurial$Hg_Sync$.MODULE$.directory(dir, Mercurial$Hg_Sync$.MODULE$.directory$default$2());
        if (verbose$1) {
            progress$1.echo(directory.log(), progress$1.echo$default$2());
        }
        return directory;
    }

    private final void resolve_components$1(Other_Isabelle other_isabelle$1, boolean verbose$2, Option clean_platforms$1, boolean clean_archives$1, String component_repository$1) {
        other_isabelle$1.resolve_components(verbose$2, (Option<List<Platform.Family>>)clean_platforms$1, clean_archives$1, component_repository$1);
    }

    private static final String $anonfun$1() {
        return Isabelle_System$.MODULE$.hostname(Isabelle_System$.MODULE$.hostname$default$1());
    }

    private static final String $anonfun$16() {
        return "\nUsage: Admin/build_other [OPTIONS] ISABELLE_HOME [ARGS ...]\n\n  Options are:\n    -A           include $ISABELLE_HOME/AFP directory\n    -B           first multicore build serves as base for scheduling information\n    -H SIZE      minimal ML heap in MB (default: " + default_heap + " for 32bit, " + default_heap * 2 + " for 64bit)\n    -M MULTICORE multicore configurations (see below)\n    -N NAME      alternative ISABELLE_IDENTIFIER (default: " + default_isabelle_identifier + ")\n    -O PLATFORMS clean resolved components, retaining only the given list\n                 platform families (separated by commas; default: do nothing)\n    -Q           clean archives of downloaded components\n    -R URL       remote repository for Isabelle components (default: " + Components$.MODULE$.static_component_repository() + ")\n    -S DIR       base directory for Isabelle components (default: " + package$.MODULE$.quote().apply((Object)Components$.MODULE$.dynamic_components_base()) + ")\n    -U SIZE      maximal ML heap in MB (default: unbounded)\n    -a           processor architecture is Apple Silicon (ARM64)\n    -e TEXT      additional text for generated etc/settings\n    -f           fresh build of Isabelle/Scala components (recommended)\n    -h NAME      override local hostname\n    -i TEXT      initial text for generated etc/settings\n    -m ARCH      processor architecture (32, 64, default: 32)\n    -n           no build: sync only\n    -o FILE      output file for log names (default: stdout)\n    -p TEXT      additional text for generated etc/preferences\n    -s NUMBER    step size for ML statistics (0=none, 1=all, n=step, default: 1)\n    -t TAG       free-form build tag (multiple occurrences possible)\n    -v           verbose\n    -x           return overall exit code from build processes\n\n  Build Isabelle sessions from the history of another REPOSITORY clone,\n  passing ARGS directly to its isabelle build tool.\n\n  Each MULTICORE configuration consists of one or two numbers (default 1):\n  THREADS or THREADSxPROCESSES, e.g. -M 1,2,4 or -M 1x4,2x2,4.\n";
    }

    private static final int $anonfun$38(BooleanRef arch_64$3) {
        if (arch_64$3.elem) {
            return default_heap * 2;
        }
        return default_heap;
    }

    private static final void main$$anonfun$1(String[] args$1) {
        BooleanRef afp = BooleanRef.create((boolean)false);
        BooleanRef multicore_base = BooleanRef.create((boolean)false);
        ObjectRef heap = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef max_heap = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef multicore_list = ObjectRef.create((Object)((List)new .colon.colon(default_multicore, (List)Nil$.MODULE$)));
        ObjectRef isabelle_identifier = ObjectRef.create((Object)default_isabelle_identifier);
        ObjectRef clean_platforms = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef clean_archives = BooleanRef.create((boolean)false);
        ObjectRef component_repository = ObjectRef.create((Object)Components$.MODULE$.static_component_repository());
        ObjectRef components_base = ObjectRef.create((Object)Components$.MODULE$.dynamic_components_base());
        BooleanRef arch_apple = BooleanRef.create((boolean)false);
        ListBuffer more_settings = new ListBuffer();
        ListBuffer more_preferences = new ListBuffer();
        BooleanRef fresh = BooleanRef.create((boolean)false);
        ObjectRef hostname = ObjectRef.create((Object)"");
        BooleanRef arch_64 = BooleanRef.create((boolean)false);
        ObjectRef output_file = ObjectRef.create((Object)"");
        IntRef ml_statistics_step = IntRef.create((int)1);
        ListBuffer build_tags = new ListBuffer();
        BooleanRef verbose = BooleanRef.create((boolean)false);
        BooleanRef exit_code = BooleanRef.create((boolean)false);
        Object[] objectArray = new Tuple2[21];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"A");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)_$5 -> {
            afp$1.elem = true;
        });
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"B");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)_$6 -> {
            multicore_base$2.elem = true;
        });
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"H:");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
            heap$2.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Value$Int$.MODULE$.parse((String)arg)));
        });
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"M:");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
            multicore_list$1.elem = ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), arg)).map((Function1 & Serializable)s -> Build_History$Multicore$.MODULE$.parse((String)s));
        });
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"N:");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (JProcedure1 & Serializable)arg -> {
            isabelle_identifier$2.elem = arg;
        });
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"O:");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (JProcedure1 & Serializable)arg -> {
            clean_platforms$3.elem = Some$.MODULE$.apply((Object)((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)','), arg)).map((Function1 & Serializable)name -> Platform$Family$.MODULE$.parse((String)name)));
        });
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Q");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (JProcedure1 & Serializable)_$7 -> {
            clean_archives$3.elem = true;
        });
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"R:");
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (JProcedure1 & Serializable)arg -> {
            component_repository$3.elem = arg;
        });
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"S:");
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (JProcedure1 & Serializable)arg -> {
            components_base$2.elem = arg;
        });
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"U:");
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (JProcedure1 & Serializable)arg -> {
            max_heap$2.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Value$Int$.MODULE$.parse((String)arg)));
        });
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"a");
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (JProcedure1 & Serializable)_$8 -> {
            arch_apple$2.elem = true;
        });
        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"e:");
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (JProcedure1 & Serializable)arg -> more_settings.$plus$eq(arg));
        String string13 = (String)Predef$.MODULE$.ArrowAssoc((Object)"f");
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string13, (JProcedure1 & Serializable)_$9 -> {
            fresh$3.elem = true;
        });
        String string14 = (String)Predef$.MODULE$.ArrowAssoc((Object)"h:");
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string14, (JProcedure1 & Serializable)arg -> {
            hostname$1.elem = arg;
        });
        String string15 = (String)Predef$.MODULE$.ArrowAssoc((Object)"m:");
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string15, (JProcedure1 & Serializable)x$1 -> {
            String string = x$1;
            if ("32".equals(string)) {
                arch_64$2.elem = false;
                return;
            }
            if ("64".equals(string)) {
                arch_64$2.elem = true;
                return;
            }
            String bad = string;
            package$.MODULE$.error().apply((Object)("Bad processor architecture: " + package$.MODULE$.quote().apply((Object)bad)));
        });
        String string16 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string16, (JProcedure1 & Serializable)arg -> {
            output_file$1.elem = arg;
        });
        String string17 = (String)Predef$.MODULE$.ArrowAssoc((Object)"p:");
        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string17, (JProcedure1 & Serializable)arg -> more_preferences.$plus$eq(arg));
        String string18 = (String)Predef$.MODULE$.ArrowAssoc((Object)"s:");
        objectArray[17] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string18, (JProcedure1 & Serializable)arg -> {
            ml_statistics_step$4.elem = Value$Int$.MODULE$.parse((String)arg);
        });
        String string19 = (String)Predef$.MODULE$.ArrowAssoc((Object)"t:");
        objectArray[18] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string19, (JProcedure1 & Serializable)arg -> build_tags.$plus$eq(arg));
        String string20 = (String)Predef$.MODULE$.ArrowAssoc((Object)"v");
        objectArray[19] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string20, (JProcedure1 & Serializable)_$10 -> {
            verbose$4.elem = true;
        });
        String string21 = (String)Predef$.MODULE$.ArrowAssoc((Object)"x");
        objectArray[20] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string21, (JProcedure1 & Serializable)_$11 -> {
            exit_code$1.elem = true;
        });
        Getopts getopts = Getopts$.MODULE$.apply((Function0<String>)((Function0 & Serializable)Build_History$::$anonfun$16), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        List<String> more_args = getopts.apply(args$1);
        List<String> list = more_args;
        if (!(list instanceof .colon.colon)) {
            throw getopts.usage(getopts.usage$default$1());
        }
        .colon.colon colon2 = (.colon.colon)list;
        List list2 = colon2.next$access$1();
        String root = (String)colon2.head();
        List build_args = list2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)Path$.MODULE$.explode(root), (Object)build_args);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path root2 = (Path)tuple2._1();
        List build_args2 = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)root2, (Object)build_args2);
        Path root3 = (Path)tuple22._1();
        List build_args3 = (List)tuple22._2();
        Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), true);
        List<Tuple2<Process_Result, Path>> results = MODULE$.local_build(Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()), root3, progress, afp.elem, (String)isabelle_identifier.elem, ml_statistics_step.elem, (String)component_repository.elem, (String)components_base.elem, (Option<List<Platform.Family>>)((Option)clean_platforms.elem), clean_archives.elem, fresh.elem, (String)hostname.elem, multicore_base.elem, (List<Tuple2<Object, Object>>)((List)multicore_list.elem), arch_64.elem, arch_apple.elem, BoxesRunTime.unboxToInt((Object)((Option)heap.elem).getOrElse(() -> Build_History$.$anonfun$38(arch_64))), (Option<Object>)((Option)max_heap.elem), (List<String>)more_settings.toList(), (List<String>)more_preferences.toList(), verbose.elem, (List<String>)build_tags.toList(), (List<String>)build_args3);
        if (((String)output_file.elem).isEmpty()) {
            results.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path log_path = (Path)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path log_path = (Path)tuple2._2();
                    Output$.MODULE$.writeln(log_path.implode(), true, Output$.MODULE$.writeln$default$3());
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            File$.MODULE$.write(Path$.MODULE$.explode((String)output_file.elem), (String)package$.MODULE$.cat_lines().apply(results.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path log_path = (Path)tuple2._2();
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path log_path = (Path)tuple2._2();
                    return log_path.implode();
                }
                throw new MatchError((Object)tuple2);
            })));
        }
        int rc = Process_Result$RC$.MODULE$.merge((IterableOnce<Object>)results.map((Function1 & Serializable)p -> ((Process_Result)p._1()).rc()));
        if (rc != Process_Result$RC$.MODULE$.ok() && exit_code.elem) {
            throw scala.sys.package$.MODULE$.exit(rc);
        }
    }

    private final void sync$1(Progress progress$3, SSH.Session ssh$1, Option afp_repos$1, Path target, boolean accurate, String rev, String afp_rev, boolean afp) {
        Rsync.Context context = Rsync$Context$.MODULE$.apply(progress$3, ssh$1, Rsync$Context$.MODULE$.apply$default$3(), Rsync$Context$.MODULE$.apply$default$4(), Rsync$Context$.MODULE$.apply$default$5(), Rsync$Context$.MODULE$.apply$default$6());
        boolean bl = !accurate;
        List<Sync.Dir> list = Sync$.MODULE$.afp_dirs((Option<Path>)(afp ? afp_repos$1 : None$.MODULE$), afp_rev);
        boolean bl2 = Sync$.MODULE$.sync$default$5();
        List<String> list2 = Sync$.MODULE$.sync$default$6();
        boolean bl3 = Sync$.MODULE$.sync$default$8();
        Sync$.MODULE$.sync(ssh$1.options(), context, target, accurate, bl2, list2, bl, bl3, rev, list);
    }

    private final boolean sync$default$2$1() {
        return false;
    }

    private final String sync$default$3$1() {
        return "";
    }

    private final String sync$default$4$1() {
        return "";
    }

    private final boolean sync$default$5$1() {
        return false;
    }

    private static final String remote_build$$anonfun$1() {
        return "tip";
    }

    private static final String remote_build$$anonfun$2() {
        return "tip";
    }

    private static final String $anonfun$40() {
        return " -A";
    }

    private static final /* synthetic */ List remote_build$$anonfun$3(Option afp_repos$2, String options$2, SSH.Session ssh$2, String component_repository$4, String components_base$3, Option clean_platforms$4, boolean clean_archives$4, Path isabelle_other$1, String args$2, Other_Isabelle self_isabelle$1, Path tmp_dir) {
        Path output_file = tmp_dir.$plus(Path$.MODULE$.explode("output"));
        String build_options = package$.MODULE$.if_proper(Option$.MODULE$.option2Iterable(afp_repos$2), (Function0<String>)((Function0 & Serializable)Build_History$::$anonfun$40)) + " " + options$2;
        try {
            Object object;
            String string = ssh$2.bash_path(Path$.MODULE$.explode("Admin/build_other"));
            String string2 = Bash$.MODULE$.string(component_repository$4);
            String string3 = Bash$.MODULE$.string(components_base$3);
            Option option = clean_platforms$4;
            if (option instanceof Some) {
                List ps = (List)((Some)option).value();
                object = " -O " + Bash$.MODULE$.string(ps.mkString(","));
            } else if (None$.MODULE$.equals(option)) {
                object = "";
            } else {
                throw new MatchError((Object)option);
            }
            String script = string + " -R " + string2 + " -S " + string3 + (String)object + (clean_archives$4 ? " -Q" : "") + " -o " + ssh$2.bash_path(output_file) + build_options + " " + ssh$2.bash_path(isabelle_other$1) + " " + args$2;
            self_isabelle$1.bash(script, self_isabelle$1.bash$default$2(), self_isabelle$1.bash$default$3(), self_isabelle$1.bash$default$4(), true, false).check();
        }
        catch (Throwable throwable) {
            String string;
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            String msg = string = (String)option.get();
            throw package$.MODULE$.cat_error((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{msg, "The error(s) above occurred for Admin/build_other " + build_options}));
        }
        return ((List)package$.MODULE$.split_lines().apply((Object)ssh$2.read(output_file))).map((Function1 & Serializable)line -> {
            Path log = Path$.MODULE$.explode((String)line);
            Bytes bytes = ssh$2.read_bytes(log);
            ssh$2.delete((Seq<Path>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{log}));
            return Tuple2$.MODULE$.apply((Object)log.file_name(), (Object)bytes);
        });
    }
}

